/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client;

import io.kubernetes.client.Discovery;
import io.kubernetes.client.apimachinery.GroupVersionKind;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.ApiException;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.kubernetes.client.ApiClientConfiguration;
import io.micronaut.kubernetes.client.ModelMapper;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(beans={Discovery.class})
@Singleton
@Internal
public class DiscoveryCache {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryCache.class);
    private static final ModelMapper MODEL_MAPPER = new ModelMapper();
    private final Discovery discovery;
    private final Duration refreshInterval;
    private Set<Discovery.APIResource> lastAPIDiscovery = new HashSet<Discovery.APIResource>();
    private volatile long nextDiscoveryRefreshTimeMillis = 0L;

    public DiscoveryCache(Discovery discovery, ApiClientConfiguration.ApiDiscoveryCacheConfiguration apiDiscoveryCacheConfiguration) {
        this.discovery = discovery;
        this.refreshInterval = Duration.ofMinutes(apiDiscoveryCacheConfiguration.getRefreshInterval());
    }

    public Set<Discovery.APIResource> findAll() throws ApiException {
        return this.getLastAPIDiscovery();
    }

    public Optional<Discovery.APIResource> find(Class<? extends KubernetesObject> clazz) {
        GroupVersionKind groupVersionKind = MODEL_MAPPER.getGroupVersionKindByClass(clazz);
        try {
            return this.getLastAPIDiscovery().stream().filter(r -> r.getKind().equalsIgnoreCase(groupVersionKind.getKind())).findFirst();
        }
        catch (ApiException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Failed to find api resource information for {}: {}", new Object[]{e.getResponseBody(), groupVersionKind.getKind(), e});
            }
            return Optional.empty();
        }
    }

    private Set<Discovery.APIResource> getLastAPIDiscovery() throws ApiException {
        long nowMillis = System.currentTimeMillis();
        if (nowMillis < this.nextDiscoveryRefreshTimeMillis) {
            return this.lastAPIDiscovery;
        }
        this.lastAPIDiscovery = this.discovery.findAll();
        this.nextDiscoveryRefreshTimeMillis = this.refreshInterval.toMillis() + nowMillis;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully fetched {} Api resources, next fetch will happen after {} minutes", (Object)this.lastAPIDiscovery.size(), (Object)this.refreshInterval.toMinutes());
        }
        return this.lastAPIDiscovery;
    }
}

