/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client;

import io.kubernetes.client.apimachinery.GroupVersionKind;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.util.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ModelMapper {
    private final Map<String, String> preBuiltApiGroups = new HashMap<String, String>();
    private final List<String> preBuiltApiVersions = new ArrayList<String>();

    public ModelMapper() {
        this.initApiGroupMap();
        this.initApiVersionList();
    }

    private void initApiGroupMap() {
        this.preBuiltApiGroups.put("Admissionregistration", "admissionregistration.k8s.io");
        this.preBuiltApiGroups.put("Apiextensions", "apiextensions.k8s.io");
        this.preBuiltApiGroups.put("Apiregistration", "apiregistration.k8s.io");
        this.preBuiltApiGroups.put("Apps", "apps");
        this.preBuiltApiGroups.put("Authentication", "authentication.k8s.io");
        this.preBuiltApiGroups.put("Authorization", "authorization.k8s.io");
        this.preBuiltApiGroups.put("Autoscaling", "autoscaling");
        this.preBuiltApiGroups.put("Batch", "batch");
        this.preBuiltApiGroups.put("Certificates", "certificates.k8s.io");
        this.preBuiltApiGroups.put("Core", "");
        this.preBuiltApiGroups.put("Extensions", "extensions");
        this.preBuiltApiGroups.put("Events", "events.k8s.io");
        this.preBuiltApiGroups.put("FlowControl", "flowcontrol.apiserver.k8s.io");
        this.preBuiltApiGroups.put("Networking", "networking.k8s.io");
        this.preBuiltApiGroups.put("Policy", "policy");
        this.preBuiltApiGroups.put("RbacAuthorization", "rbac.authorization.k8s.io");
        this.preBuiltApiGroups.put("Scheduling", "scheduling.k8s.io");
        this.preBuiltApiGroups.put("Settings", "settings.k8s.io");
        this.preBuiltApiGroups.put("Storage", "storage.k8s.io");
    }

    private void initApiVersionList() {
        this.preBuiltApiVersions.add("V2beta1");
        this.preBuiltApiVersions.add("V2beta2");
        this.preBuiltApiVersions.add("V2alpha1");
        this.preBuiltApiVersions.add("V1beta2");
        this.preBuiltApiVersions.add("V1beta1");
        this.preBuiltApiVersions.add("V1alpha1");
        this.preBuiltApiVersions.add("V1");
    }

    private Pair<String, String> getApiGroup(String name) {
        return (Pair)this.preBuiltApiGroups.entrySet().stream().filter(e -> name.startsWith((String)e.getKey())).map(e -> new MutablePair(e.getValue(), (Object)name.substring(((String)e.getKey()).length()))).findFirst().orElse(new MutablePair(null, (Object)name));
    }

    private Pair<String, String> getApiVersion(String name) {
        return (Pair)this.preBuiltApiVersions.stream().filter(name::startsWith).map(v -> new MutablePair((Object)v.toLowerCase(), (Object)name.substring(v.length()))).findFirst().orElse(new MutablePair(null, (Object)name));
    }

    public GroupVersionKind getGroupVersionKindByClass(Class<? extends KubernetesObject> clazz) {
        Pair<String, String> groupAndOther = this.getApiGroup(clazz.getSimpleName());
        Pair<String, String> versionAndOther = this.getApiVersion((String)groupAndOther.getRight());
        String group = Strings.nullToEmpty((String)((String)groupAndOther.getLeft()));
        String version = (String)versionAndOther.getLeft();
        String kind = (String)versionAndOther.getRight();
        return new GroupVersionKind(group, version, kind);
    }
}

