/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.graalvm;

import com.oracle.svm.core.annotate.AutomaticFeature;
import io.micronaut.core.annotation.Internal;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@AutomaticFeature
@Internal
public class KubernetesClientFeature
implements Feature {
    static final boolean DEBUG_OUTPUT = false;

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        HashSet<Class> reflectiveAccess = new HashSet<Class>();
        Arrays.asList("io.kubernetes.client.util.Watch$Response", "io.kubernetes.client.custom.Quantity$QuantityAdapter", "io.kubernetes.client.custom.IntOrString$IntOrStringAdapter").forEach(cls -> {
            Class c = access.findClassByName(cls);
            reflectiveAccess.add(c);
        });
        String[] classes = new String[]{};
        try {
            Set<String> classesList = KubernetesClientFeature.getClassNamesFromPackage(access.getApplicationClassLoader(), "io.kubernetes.client.openapi.models");
            classes = classesList.toArray(new String[0]);
        }
        catch (IOException e) {
            System.out.println("Failed to load K8s client models: " + e);
        }
        for (String aClass : classes) {
            Class c = access.findClassByName(aClass);
            reflectiveAccess.add(c);
        }
        for (Class type : reflectiveAccess) {
            boolean hasNoArgsConstructor = !type.isEnum() && !type.isInterface() && this.hasNoArgsConstructor(type.getDeclaredConstructors());
            RuntimeReflection.register((Class[])new Class[]{type});
            if (hasNoArgsConstructor) {
                RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{type});
            }
            for (Method method : type.getDeclaredMethods()) {
                RuntimeReflection.register((Executable[])new Executable[]{method});
            }
            if (type.isInterface()) continue;
            for (AccessibleObject accessibleObject : type.getDeclaredFields()) {
                RuntimeReflection.register((Field[])new Field[]{accessibleObject});
            }
        }
    }

    private static Set<String> getClassNamesFromPackage(ClassLoader classLoader, String pkg) throws IOException {
        HashSet<String> names = new HashSet<String>();
        String packageName = pkg.replace(".", "/");
        Enumeration<URL> resources = classLoader.getResources(packageName);
        while (resources.hasMoreElements()) {
            String entryName;
            URL packageURL = resources.nextElement();
            if (packageURL.getProtocol().equals("jar")) {
                String jarFileName = URLDecoder.decode(packageURL.getFile(), "UTF-8");
                jarFileName = jarFileName.substring(5, jarFileName.indexOf("!"));
                JarFile jf = new JarFile(jarFileName);
                Enumeration<JarEntry> jarEntries = jf.entries();
                while (jarEntries.hasMoreElements()) {
                    entryName = jarEntries.nextElement().getName();
                    if (!entryName.startsWith(packageName) || entryName.length() <= packageName.length() + 5 || !KubernetesClientFeature.isKubernetesClientObject(entryName = entryName.substring(packageName.length() + 1, entryName.lastIndexOf(46)))) continue;
                    names.add(pkg + "." + entryName);
                }
                jf.close();
                continue;
            }
            URI uri = URI.create(packageURL.toString());
            File folder = new File(uri.getPath());
            File[] contenuti = folder.listFiles();
            if (contenuti == null) {
                return names;
            }
            for (File actual : contenuti) {
                entryName = actual.getName();
                if (!KubernetesClientFeature.isKubernetesClientObject(entryName = entryName.substring(0, entryName.lastIndexOf(46)))) continue;
                names.add(pkg + "." + entryName);
            }
        }
        return names;
    }

    private static boolean isKubernetesClientObject(String classname) {
        return Stream.of("Fluent", "Builder").noneMatch(classname::contains);
    }

    private boolean hasNoArgsConstructor(Constructor<?>[] declaredConstructors) {
        boolean hasNoArgsConstructor = false;
        for (Constructor<?> declaredConstructor : declaredConstructors) {
            if (declaredConstructor.getParameterCount() != 0) continue;
            hasNoArgsConstructor = true;
            break;
        }
        return hasNoArgsConstructor;
    }
}

