/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.util.ClientBuilder;
import io.kubernetes.client.util.KubeConfig;
import io.kubernetes.client.util.credentials.Authentication;
import io.kubernetes.client.util.credentials.TokenFileAuthentication;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.ApiClientConfiguration;
import io.micronaut.kubernetes.client.OkHttpClientLogging;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.ExecutorService;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
@BootstrapContextCompatible
public class ApiClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ApiClientFactory.class);

    @Singleton
    public ClientBuilder clientBuilder(ApiClientConfiguration apiClientConfiguration) throws IOException {
        ClientBuilder clientBuilder = null;
        if (apiClientConfiguration.getKubeConfigPath().isPresent()) {
            String customKubeConfigPath = apiClientConfiguration.getKubeConfigPath().get();
            if (new File(customKubeConfigPath).exists()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Using custom kube config from path: {}", (Object)customKubeConfigPath);
                }
                KubeConfig kubeConfig = KubeConfig.loadKubeConfig((Reader)new FileReader(customKubeConfigPath));
                clientBuilder = ClientBuilder.kubeconfig((KubeConfig)kubeConfig);
            } else if (LOG.isWarnEnabled()) {
                LOG.warn("Custom kube config path '{}' defined but file doesn't exists", (Object)customKubeConfigPath);
            }
        }
        if (clientBuilder == null) {
            clientBuilder = ClientBuilder.standard();
        }
        this.updateBuilderConfiguration(apiClientConfiguration, clientBuilder);
        return clientBuilder;
    }

    public ApiClient apiClient(ClientBuilder clientBuilder) throws IOException {
        return this.apiClient(clientBuilder, null);
    }

    @Singleton
    public ApiClient apiClient(ClientBuilder clientBuilder, @Nullable @Named(value="io") ExecutorService executorService) throws IOException {
        ApiClient apiClient = clientBuilder.build();
        Configuration.setDefaultApiClient((ApiClient)apiClient);
        OkHttpClient.Builder builder = apiClient.getHttpClient().newBuilder();
        builder.addInterceptor((Interceptor)new OkHttpClientLogging());
        if (executorService != null) {
            builder.dispatcher(new Dispatcher(executorService));
        }
        apiClient.setHttpClient(builder.build());
        return apiClient;
    }

    private void updateBuilderConfiguration(ApiClientConfiguration apiClientConfiguration, ClientBuilder builder) {
        block8: {
            builder.setVerifyingSsl(apiClientConfiguration.getVerifySsl());
            if (apiClientConfiguration.getBasePath().isPresent()) {
                String basePath = apiClientConfiguration.getBasePath().get();
                if (LOG.isInfoEnabled()) {
                    LOG.info("Configuring basePath '{}'", (Object)basePath);
                }
                builder.setBasePath(basePath);
            }
            if (apiClientConfiguration.getCaPath().isPresent()) {
                String caPath = apiClientConfiguration.getCaPath().get();
                try {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Configuring caPath '{}'", (Object)caPath);
                    }
                    builder.setCertificateAuthority(Files.readAllBytes(Paths.get(caPath, new String[0])));
                }
                catch (IOException e) {
                    if (!LOG.isErrorEnabled()) break block8;
                    LOG.error("Failed to load caPath from '{}': {}", new Object[]{caPath, e.getMessage(), e});
                }
            }
        }
        if (apiClientConfiguration.getTokenPath().isPresent()) {
            String tokenPath = apiClientConfiguration.getTokenPath().get();
            if (LOG.isInfoEnabled()) {
                LOG.info("Configuring tokenPath '{}'", (Object)tokenPath);
            }
            builder.setAuthentication((Authentication)new TokenFileAuthentication(tokenPath));
        }
    }
}

