/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.discovery.DiscoveryConfiguration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(env={"k8s"})
@ConfigurationProperties(value="kubernetes.client")
@BootstrapContextCompatible
public class KubernetesConfiguration {
    public static final String PREFIX = "kubernetes.client";
    public static final String NAMESPACE_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/namespace";
    public static final String DEFAULT_NAMESPACE = "default";
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesConfiguration.class);
    private String namespace;
    private KubernetesDiscoveryConfiguration discovery = new KubernetesDiscoveryConfiguration();
    private KubernetesSecretsConfiguration secrets = new KubernetesSecretsConfiguration();
    private KubernetesConfigMapsConfiguration configMaps = new KubernetesConfigMapsConfiguration();

    public KubernetesConfiguration() {
        if (this.namespace == null) {
            String namespace = DEFAULT_NAMESPACE;
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Namespace has not been set. Reading it from file [{}]", (Object)NAMESPACE_PATH);
                }
                namespace = new String(Files.readAllBytes(Paths.get(NAMESPACE_PATH, new String[0])));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Namespace: [{}]", (Object)namespace);
                }
            }
            catch (IOException ioe) {
                LOG.warn("An error has occurred when reading the file: [/var/run/secrets/kubernetes.io/serviceaccount/namespace]. Kubernetes namespace will be set to: default");
            }
            this.namespace = namespace;
        }
    }

    @NonNull
    public KubernetesDiscoveryConfiguration getDiscovery() {
        return this.discovery;
    }

    public void setDiscovery(KubernetesDiscoveryConfiguration discoveryConfiguration) {
        this.discovery = discoveryConfiguration;
    }

    @NonNull
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @NonNull
    public KubernetesSecretsConfiguration getSecrets() {
        return this.secrets;
    }

    public void setSecrets(KubernetesSecretsConfiguration secretsConfiguration) {
        this.secrets = secretsConfiguration;
    }

    @NonNull
    public KubernetesConfigMapsConfiguration getConfigMaps() {
        return this.configMaps;
    }

    public void setConfigMaps(KubernetesConfigMapsConfiguration configMapsConfiguration) {
        this.configMaps = configMapsConfiguration;
    }

    public String toString() {
        return "KubernetesConfiguration{namespace='" + this.namespace + '\'' + ", discovery=" + (Object)((Object)this.discovery) + ", secrets=" + (Object)((Object)this.secrets) + ", configMaps=" + (Object)((Object)this.configMaps) + '}';
    }

    @ConfigurationProperties(value="config-maps")
    @BootstrapContextCompatible
    public static class KubernetesConfigMapsConfiguration
    extends AbstractKubernetesConfiguration {
        public static final String PREFIX = "config-maps";
    }

    @ConfigurationProperties(value="secrets")
    @BootstrapContextCompatible
    public static class KubernetesSecretsConfiguration
    extends AbstractKubernetesConfiguration {
        static final String PREFIX = "secrets";
        static final boolean DEFAULT_ENABLED = false;
        private boolean enabled = false;
        private Collection<String> paths;
        private boolean useApi;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Collection<String> getPaths() {
            if (this.paths == null) {
                return Collections.emptySet();
            }
            return this.paths;
        }

        public void setPaths(Collection<String> paths) {
            this.paths = paths;
        }

        public boolean isUseApi() {
            return this.useApi;
        }

        public void setUseApi(boolean useApi) {
            this.useApi = useApi;
        }
    }

    private static abstract class AbstractKubernetesConfiguration
    extends DiscoveryConfiguration {
        private Collection<String> includes = new HashSet<String>();
        private Collection<String> excludes = new HashSet<String>();
        private Map<String, String> labels;
        private List<String> podLabels;

        private AbstractKubernetesConfiguration() {
        }

        public Collection<String> getIncludes() {
            return this.includes;
        }

        public void setIncludes(Collection<String> includes) {
            this.includes = includes;
        }

        public Collection<String> getExcludes() {
            return this.excludes;
        }

        public void setExcludes(Collection<String> excludes) {
            this.excludes = excludes;
        }

        public Map<String, String> getLabels() {
            if (this.labels == null) {
                return Collections.emptyMap();
            }
            return this.labels;
        }

        public void setLabels(Map<String, String> labels) {
            this.labels = labels;
        }

        public List<String> getPodLabels() {
            if (this.podLabels == null) {
                return Collections.emptyList();
            }
            return this.podLabels;
        }

        public void setPodLabels(List<String> podLabels) {
            this.podLabels = podLabels;
        }
    }

    @ConfigurationProperties(value="discovery")
    @BootstrapContextCompatible
    public static class KubernetesDiscoveryConfiguration
    extends AbstractKubernetesConfiguration {
        public static final String DEFAULT_MODE = "endpoint";
        public static final String PREFIX = "kubernetes.client.discovery";
        private String mode = "endpoint";

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }
    }
}

