/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.configuration;

import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.util.Watch;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.discovery.event.ServiceReadyEvent;
import io.micronaut.kubernetes.KubernetesConfiguration;
import io.micronaut.kubernetes.client.reactor.CoreV1ApiReactorClient;
import io.micronaut.kubernetes.configuration.KubernetesConfigurationClient;
import io.micronaut.kubernetes.util.KubernetesUtils;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import okhttp3.Call;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requirements(value={@Requires(env={"k8s"}), @Requires(beans={CoreV1ApiReactorClient.class}), @Requires(property="kubernetes.client.config-maps.watch", notEquals="false", defaultValue="true")})
public class KubernetesConfigMapWatcher
implements ApplicationEventListener<ServiceReadyEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesConfigMapWatcher.class);
    private final Environment environment;
    private final ApiClient apiClient;
    private final CoreV1Api coreV1Api;
    private final CoreV1ApiReactorClient coreV1ApiReactorClient;
    private final KubernetesConfiguration configuration;
    private final ExecutorService executorService;
    private final ApplicationEventPublisher<RefreshEvent> eventPublisher;

    public KubernetesConfigMapWatcher(Environment environment, ApiClient apiClient, CoreV1Api coreV1Api, CoreV1ApiReactorClient coreV1ApiReactorClient, KubernetesConfiguration configuration, @Named(value="io") ExecutorService executorService, ApplicationEventPublisher<RefreshEvent> eventPublisher) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing {}", (Object)this.getClass().getName());
        }
        this.environment = environment;
        this.apiClient = apiClient;
        this.coreV1Api = coreV1Api;
        this.coreV1ApiReactorClient = coreV1ApiReactorClient;
        this.configuration = configuration;
        this.executorService = executorService;
        this.eventPublisher = eventPublisher;
    }

    public void onApplicationEvent(ServiceReadyEvent event) {
        this.executorService.execute(this::watch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watch() {
        block9: while (true) {
            Watch watch;
            String lastResourceVersion = this.computeLastResourceVersion();
            Map labels = this.configuration.getConfigMaps().getLabels();
            String labelSelector = (String)KubernetesUtils.computePodLabelSelector(this.coreV1ApiReactorClient, this.configuration.getConfigMaps().getPodLabels(), this.configuration.getNamespace(), labels).block();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Watching for ConfigMap events...");
            }
            try {
                watch = Watch.createWatch((ApiClient)this.apiClient, (Call)this.coreV1Api.listNamespacedConfigMapCall(this.configuration.getNamespace(), null, null, null, null, labelSelector, null, lastResourceVersion, null, null, Boolean.TRUE, null), (Type)new TypeToken<Watch.Response<V1ConfigMap>>(){}.getType());
            }
            catch (ApiException e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error("Failed to create the config map watch: " + e.getMessage(), (Throwable)e);
                continue;
            }
            try {
                Iterator e = watch.iterator();
                while (true) {
                    if (!e.hasNext()) continue block9;
                    Watch.Response item = (Watch.Response)e.next();
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Received ConfigMap watch event: {}", (Object)item);
                    }
                    this.processEvent((Watch.Response<V1ConfigMap>)item);
                }
            }
            finally {
                try {
                    watch.close();
                }
                catch (IOException e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error("Failed to close the config map watch: " + e.getMessage(), (Throwable)e);
                }
                continue;
            }
            break;
        }
    }

    private String computeLastResourceVersion() {
        String lastResourceVersion = this.environment.getPropertySources().stream().filter(propertySource -> propertySource.getName().equals("Kubernetes ConfigMapList")).map(propertySource -> propertySource.get("configMapListResourceVersion")).map(o -> Long.parseLong(o.toString())).max(Long::compareTo).orElse(0L).toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Latest resourceVersion is: {}", (Object)lastResourceVersion);
        }
        return lastResourceVersion;
    }

    private void processEvent(Watch.Response<V1ConfigMap> event) {
        switch (event.type) {
            case "ADDED": {
                this.processConfigMapAdded((V1ConfigMap)event.object);
                break;
            }
            case "MODIFIED": {
                this.processConfigMapModified((V1ConfigMap)event.object);
                break;
            }
            case "DELETED": {
                this.processConfigMapDeleted((V1ConfigMap)event.object);
                break;
            }
            default: {
                this.processConfigMapErrored(event);
            }
        }
    }

    private void processConfigMapAdded(V1ConfigMap configMap) {
        PropertySource propertySource = null;
        if (configMap != null) {
            propertySource = KubernetesUtils.configMapAsPropertySource(configMap);
        }
        if (this.passesIncludesExcludesLabelsFilters(configMap)) {
            KubernetesConfigurationClient.addPropertySourceToCache(propertySource);
            this.refreshEnvironment();
        }
    }

    private void processConfigMapModified(V1ConfigMap configMap) {
        PropertySource propertySource = null;
        if (configMap != null) {
            propertySource = KubernetesUtils.configMapAsPropertySource(configMap);
        }
        if (this.passesIncludesExcludesLabelsFilters(configMap)) {
            KubernetesConfigurationClient.removePropertySourceFromCache(propertySource.getName());
            KubernetesConfigurationClient.addPropertySourceToCache(propertySource);
            this.refreshEnvironment();
        }
    }

    private void processConfigMapDeleted(V1ConfigMap configMap) {
        PropertySource propertySource = null;
        if (configMap != null) {
            propertySource = KubernetesUtils.configMapAsPropertySource(configMap);
        }
        if (this.passesIncludesExcludesLabelsFilters(configMap)) {
            KubernetesConfigurationClient.removePropertySourceFromCache(propertySource.getName());
            this.refreshEnvironment();
        }
    }

    private void refreshEnvironment() {
        Map changes = this.environment.refreshAndDiff();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Changes in ConfigMap property sources: [{}]", (Object)String.join((CharSequence)", ", changes.keySet()));
        }
        if (!changes.isEmpty()) {
            this.eventPublisher.publishEvent((Object)new RefreshEvent(changes));
        }
    }

    private void processConfigMapErrored(Watch.Response<V1ConfigMap> event) {
        LOG.error("Kubernetes API returned an error for a ConfigMap watch event: {}", (Object)event.toString());
        KubernetesConfigurationClient.getPropertySourceCache().clear();
        this.refreshEnvironment();
        this.watch();
    }

    private boolean passesIncludesExcludesLabelsFilters(V1ConfigMap configMap) {
        Collection includes = this.configuration.getConfigMaps().getIncludes();
        Collection excludes = this.configuration.getConfigMaps().getExcludes();
        boolean process = true;
        if (!includes.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("ConfigMap includes: {}", (Object)includes);
            }
            process = includes.contains(configMap.getMetadata().getName());
        } else if (!excludes.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("ConfigMap excludes: {}", (Object)excludes);
            }
            boolean bl = process = !excludes.contains(configMap.getMetadata().getName());
        }
        if (!process && LOG.isTraceEnabled()) {
            LOG.trace("ConfigMap {} not added because it doesn't match includes/excludes filters", (Object)configMap.getMetadata().getName());
        }
        return process;
    }
}

