/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.discovery;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.discovery.DiscoveryClient;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.kubernetes.KubernetesConfiguration;
import io.micronaut.kubernetes.client.reactor.CoreV1ApiReactorClient;
import io.micronaut.kubernetes.discovery.KubernetesServiceConfiguration;
import io.micronaut.kubernetes.discovery.KubernetesServiceInstanceList;
import io.micronaut.kubernetes.discovery.KubernetesServiceInstanceProvider;
import io.micronaut.kubernetes.util.KubernetesUtils;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

@Singleton
@Requirements(value={@Requires(env={"k8s"}), @Requires(property="kubernetes.client.discovery.enabled", notEquals="false", defaultValue="true")})
public class KubernetesDiscoveryClient
implements DiscoveryClient {
    public static final String SERVICE_ID = "kubernetes";
    protected static final Logger LOG = LoggerFactory.getLogger(KubernetesDiscoveryClient.class);
    private final CoreV1ApiReactorClient client;
    private final KubernetesConfiguration configuration;
    private final KubernetesConfiguration.KubernetesDiscoveryConfiguration discoveryConfiguration;
    private final Map<String, KubernetesServiceConfiguration> serviceConfigurations;
    private final Map<String, KubernetesServiceInstanceProvider> instanceProviders;
    private final KubernetesServiceInstanceList instanceList;

    @Inject
    public KubernetesDiscoveryClient(CoreV1ApiReactorClient client, KubernetesConfiguration configuration, KubernetesConfiguration.KubernetesDiscoveryConfiguration discoveryConfiguration, List<KubernetesServiceConfiguration> serviceConfigurations, List<KubernetesServiceInstanceProvider> instanceProviders, KubernetesServiceInstanceList instanceList) {
        this.client = client;
        this.configuration = configuration;
        this.discoveryConfiguration = discoveryConfiguration;
        this.serviceConfigurations = serviceConfigurations.stream().collect(Collectors.toMap(KubernetesServiceConfiguration::getServiceId, Function.identity()));
        this.instanceProviders = instanceProviders.stream().collect(Collectors.toMap(KubernetesServiceInstanceProvider::getMode, Function.identity()));
        this.instanceList = instanceList;
    }

    public Publisher<List<ServiceInstance>> getInstances(String serviceId) {
        String mode;
        if (!this.discoveryConfiguration.isEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Discovery configuration is not enabled");
            }
            return Publishers.just(Collections.emptyList());
        }
        if (SERVICE_ID.equals(serviceId)) {
            return Publishers.just(this.instanceList.getInstances());
        }
        KubernetesServiceConfiguration serviceConfiguration = this.serviceConfigurations.computeIfAbsent(serviceId, key -> new KubernetesServiceConfiguration((String)key, false));
        if (!serviceConfiguration.getNamespace().isPresent()) {
            serviceConfiguration.setNamespace(this.configuration.getNamespace());
        }
        if (!serviceConfiguration.getName().isPresent()) {
            serviceConfiguration.setName(serviceId);
        }
        if (!serviceConfiguration.getMode().isPresent()) {
            serviceConfiguration.setMode(this.configuration.getDiscovery().getMode());
        }
        if (!this.instanceProviders.containsKey(mode = serviceConfiguration.getMode().get())) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Unrecognized kubernetes discovery mode: [" + mode + "], out of supported ones: [ " + String.join((CharSequence)",", this.instanceProviders.keySet()) + "]");
            }
            return Publishers.just(Collections.emptyList());
        }
        return this.instanceProviders.get(mode).getInstances(serviceConfiguration);
    }

    public Publisher<List<String>> getServiceIds() {
        String namespace = this.configuration.getNamespace();
        Map labels = this.configuration.getDiscovery().getLabels();
        String labelSelector = KubernetesUtils.computeLabelSelector(labels);
        Predicate<KubernetesObject> includesFilter = KubernetesUtils.getIncludesFilter(this.discoveryConfiguration.getIncludes());
        Predicate<KubernetesObject> excludesFilter = KubernetesUtils.getExcludesFilter(this.discoveryConfiguration.getExcludes());
        return Flux.merge((Publisher[])new Publisher[]{Flux.fromIterable(this.serviceConfigurations.keySet()), this.client.listNamespacedService(namespace, null, null, null, null, labelSelector, null, null, null, null).doOnError(ApiException.class, throwable -> LOG.error("Failed to list Services in namespace [" + namespace + "]:" + throwable.getResponseBody(), (Throwable)throwable)).flatMapIterable(V1ServiceList::getItems).filter(includesFilter).filter(excludesFilter).mapNotNull(service -> Optional.ofNullable(service.getMetadata()).map(V1ObjectMeta::getName).orElse(null))}).distinct().collectList();
    }

    @NonNull
    public String getDescription() {
        return SERVICE_ID;
    }

    public void close() {
    }
}

