/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.configuration;

import io.kubernetes.client.informer.ResourceEventHandler;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1ConfigMapList;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.discovery.event.ServiceReadyEvent;
import io.micronaut.kubernetes.KubernetesConfiguration;
import io.micronaut.kubernetes.client.informer.Informer;
import io.micronaut.kubernetes.client.reactor.CoreV1ApiReactorClient;
import io.micronaut.kubernetes.configuration.ConfigMapLabelSupplier;
import io.micronaut.kubernetes.configuration.KubernetesConfigMapWatcherCondition;
import io.micronaut.kubernetes.configuration.KubernetesConfigurationClient;
import io.micronaut.kubernetes.util.KubernetesUtils;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import io.micronaut.runtime.event.annotation.EventListener;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Context
@Requirements(value={@Requires(env={"k8s"}), @Requires(beans={CoreV1ApiReactorClient.class}), @Requires(condition=KubernetesConfigMapWatcherCondition.class)})
@Informer(apiType=V1ConfigMap.class, apiListType=V1ConfigMapList.class, resourcePlural="configmaps", apiGroup="", labelSelectorSupplier=ConfigMapLabelSupplier.class)
public class KubernetesConfigMapWatcher
implements ResourceEventHandler<V1ConfigMap> {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesConfigMapWatcher.class);
    private final Environment environment;
    private final KubernetesConfiguration configuration;
    private final ApplicationEventPublisher<RefreshEvent> eventPublisher;
    private final AtomicBoolean serviceStarted = new AtomicBoolean(false);

    public KubernetesConfigMapWatcher(Environment environment, ApiClient apiClient, CoreV1Api coreV1Api, CoreV1ApiReactorClient coreV1ApiReactorClient, KubernetesConfiguration configuration, @Named(value="io") ExecutorService executorService, ApplicationEventPublisher<RefreshEvent> eventPublisher) {
        this(environment, configuration, eventPublisher);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing {}", (Object)this.getClass().getName());
        }
    }

    @Inject
    public KubernetesConfigMapWatcher(Environment environment, KubernetesConfiguration configuration, ApplicationEventPublisher<RefreshEvent> eventPublisher) {
        this.environment = environment;
        this.configuration = configuration;
        this.eventPublisher = eventPublisher;
    }

    @EventListener
    public void onApplicationEvent(ServiceReadyEvent event) {
        this.serviceStarted.set(true);
    }

    public void onAdd(V1ConfigMap configMap) {
        if (!this.serviceStarted.get()) {
            return;
        }
        PropertySource propertySource = null;
        if (configMap != null) {
            propertySource = KubernetesUtils.configMapAsPropertySource(configMap);
        }
        if (this.passesIncludesExcludesLabelsFilters(configMap)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("PropertySource created from ConfigMap: {}", (Object)configMap.getMetadata().getName());
            }
            KubernetesConfigurationClient.addPropertySourceToCache(propertySource);
            this.refreshEnvironment();
        }
    }

    public void onUpdate(V1ConfigMap oldObj, V1ConfigMap configMap) {
        if (!this.serviceStarted.get()) {
            return;
        }
        PropertySource propertySource = null;
        if (configMap != null) {
            propertySource = KubernetesUtils.configMapAsPropertySource(configMap);
        }
        if (this.passesIncludesExcludesLabelsFilters(configMap)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("PropertySource modified by ConfigMap: {}", (Object)configMap.getMetadata().getName());
            }
            KubernetesConfigurationClient.removePropertySourceFromCache(propertySource.getName());
            KubernetesConfigurationClient.addPropertySourceToCache(propertySource);
            this.refreshEnvironment();
        }
    }

    public void onDelete(V1ConfigMap configMap, boolean deletedFinalStateUnknown) {
        if (!this.serviceStarted.get()) {
            return;
        }
        PropertySource propertySource = null;
        if (configMap != null) {
            propertySource = KubernetesUtils.configMapAsPropertySource(configMap);
        }
        if (this.passesIncludesExcludesLabelsFilters(configMap)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removed PropertySource created from ConfigMap: {}", (Object)configMap.getMetadata().getName());
            }
            KubernetesConfigurationClient.removePropertySourceFromCache(propertySource.getName());
            this.refreshEnvironment();
        }
    }

    private void refreshEnvironment() {
        Map changes = this.environment.refreshAndDiff();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Changes in ConfigMap property sources: [{}]", (Object)String.join((CharSequence)", ", changes.keySet()));
        }
        if (!changes.isEmpty()) {
            this.eventPublisher.publishEvent((Object)new RefreshEvent(changes));
        }
    }

    private boolean passesIncludesExcludesLabelsFilters(V1ConfigMap configMap) {
        Collection includes = this.configuration.getConfigMaps().getIncludes();
        Collection excludes = this.configuration.getConfigMaps().getExcludes();
        boolean process = true;
        if (!includes.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("ConfigMap includes: {}", (Object)includes);
            }
            process = includes.contains(configMap.getMetadata().getName());
        } else if (!excludes.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("ConfigMap excludes: {}", (Object)excludes);
            }
            boolean bl = process = !excludes.contains(configMap.getMetadata().getName());
        }
        if (!process && LOG.isTraceEnabled()) {
            LOG.trace("ConfigMap {} not added because it doesn't match includes/excludes filters", (Object)configMap.getMetadata().getName());
        }
        return process;
    }
}

