/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.configuration;

import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.kubernetes.KubernetesConfiguration;

@Internal
public class KubernetesConfigMapWatcherCondition
implements Condition {
    public boolean matches(ConditionContext context) {
        KubernetesConfiguration.KubernetesConfigMapsConfiguration configMapsConfiguration = (KubernetesConfiguration.KubernetesConfigMapsConfiguration)((Object)context.getBean(KubernetesConfiguration.KubernetesConfigMapsConfiguration.class));
        if (!configMapsConfiguration.isEnabled()) {
            context.fail("configuration client for the ConfigMaps is disabled");
            return false;
        }
        if (!configMapsConfiguration.isWatch()) {
            context.fail("watch for the ConfigMap changes is disabled");
            return false;
        }
        if (!configMapsConfiguration.getPaths().isEmpty() && !configMapsConfiguration.isUseApi()) {
            context.fail("config maps paths configuration for mounted volumes is specified and use api is disabled");
            return false;
        }
        return true;
    }
}

