/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.discovery;

import io.kubernetes.client.util.ClientBuilder;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requires;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.ServiceInstanceList;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.Collections;
import java.util.List;

@Singleton
@Requires(env={"k8s"})
@BootstrapContextCompatible
public class KubernetesServiceInstanceList
implements ServiceInstanceList {
    private final ClientBuilder configuration;

    public KubernetesServiceInstanceList(ClientBuilder clientBuilder) {
        this.configuration = clientBuilder;
    }

    public String getID() {
        return "kubernetes";
    }

    public List<ServiceInstance> getInstances() {
        return Collections.singletonList(ServiceInstance.builder((String)this.getID(), (URI)URI.create(this.configuration.getBasePath())).build());
    }
}

