/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.health;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.V1ContainerStatus;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodStatus;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.health.HealthStatus;
import io.micronaut.kubernetes.KubernetesConfiguration;
import io.micronaut.kubernetes.client.reactor.CoreV1ApiReactorClient;
import io.micronaut.management.endpoint.health.HealthEndpoint;
import io.micronaut.management.health.indicator.AbstractHealthIndicator;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requirements(value={@Requires(beans={HealthEndpoint.class}), @Requires(env={"k8s"}), @Requires(property="hostname")})
public class KubernetesHealthIndicator
extends AbstractHealthIndicator<Map<String, Object>> {
    public static final String NAME = "kubernetes";
    public static final String HOSTNAME_ENV_VARIABLE = "HOSTNAME";
    public static final String HOSTNAME_ENV_VARIABLE_IN_PROPERTY_FORMAT = "hostname";
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesHealthIndicator.class);
    private final CoreV1ApiReactorClient client;
    private final KubernetesConfiguration configuration;

    public KubernetesHealthIndicator(CoreV1ApiReactorClient client, KubernetesConfiguration configuration) {
        this.client = client;
        this.configuration = configuration;
        this.healthStatus = HealthStatus.UP;
    }

    private Map<String, Object> processError(Throwable throwable) {
        LOG.warn("Error while getting Pod information", throwable);
        LinkedHashMap<String, Object> healthInformation = new LinkedHashMap<String, Object>();
        healthInformation.put("error", throwable.getMessage());
        this.healthStatus = HealthStatus.UNKNOWN;
        return healthInformation;
    }

    private Map<String, Object> processPod(V1Pod pod) {
        Optional<V1PodStatus> podStatusOptional;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing pod: {}", (Object)pod);
        }
        this.healthStatus = HealthStatus.UP;
        LinkedHashMap<String, Object> healthInformation = new LinkedHashMap<String, Object>();
        Optional<V1ObjectMeta> metaOptional = Optional.ofNullable(pod.getMetadata());
        if (metaOptional.isPresent()) {
            V1ObjectMeta objectMeta = metaOptional.get();
            healthInformation.put("namespace", objectMeta.getNamespace());
            healthInformation.put("podName", objectMeta.getName());
        }
        if ((podStatusOptional = Optional.ofNullable(pod.getStatus())).isPresent()) {
            V1PodStatus podStatus = podStatusOptional.get();
            healthInformation.put("podPhase", podStatus.getPhase());
            healthInformation.put("podIP", podStatus.getPodIP());
            healthInformation.put("hostIP", podStatus.getHostIP());
            healthInformation.put("containerStatuses", Objects.requireNonNull(podStatus.getContainerStatuses()).stream().collect(ArrayList::new, KubernetesHealthIndicator::accumulateContainerStatus, ArrayList::addAll));
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Pod health information: {}", healthInformation);
        }
        return healthInformation;
    }

    private static void accumulateContainerStatus(ArrayList<Object> list, V1ContainerStatus containerStatus) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing containerStatus: {}", (Object)containerStatus);
        }
        LinkedHashMap<String, Object> cs = new LinkedHashMap<String, Object>();
        cs.put("name", containerStatus.getName());
        cs.put("image", containerStatus.getImage());
        cs.put("ready", containerStatus.getReady());
        cs.put("restartCount", containerStatus.getRestartCount());
        list.add(cs);
    }

    protected Map<String, Object> getHealthInformation() {
        try {
            String podName = System.getenv(HOSTNAME_ENV_VARIABLE);
            String podNamespace = this.configuration.getNamespace();
            if (podName != null) {
                V1Pod pod = (V1Pod)this.client.readNamespacedPod(podName, podNamespace, null, null, null).doOnError(ApiException.class, throwable -> LOG.error("Failed to read Pod [" + podName + "] from namespace [" + podNamespace + "]: " + throwable.getResponseBody(), (Throwable)throwable)).block();
                return this.processPod(pod);
            }
            return Collections.emptyMap();
        }
        catch (Exception e) {
            return this.processError(e);
        }
    }

    protected String getName() {
        return NAME;
    }
}

