/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.util;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1Secret;
import io.micronaut.context.env.PropertiesPropertySourceLoader;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.env.PropertySourceReader;
import io.micronaut.context.env.yaml.YamlPropertySourceLoader;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.jackson.env.JsonPropertySourceLoader;
import io.micronaut.kubernetes.client.reactor.CoreV1ApiReactorClient;
import io.micronaut.kubernetes.configuration.KubernetesConfigurationClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class KubernetesUtils {
    public static final String ENV_KUBERNETES_SERVICE_HOST = "KUBERNETES_SERVICE_HOST";
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesUtils.class);
    private static final List<PropertySourceReader> PROPERTY_SOURCE_READERS = Arrays.asList(new YamlPropertySourceLoader(), new JsonPropertySourceLoader(), new PropertiesPropertySourceLoader());

    public static PropertySource configMapAsPropertySource(V1ConfigMap configMap) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing PropertySources for ConfigMap: {}", (Object)configMap);
        }
        String name = KubernetesUtils.getPropertySourceName(configMap);
        Map data = configMap.getData();
        if (data == null || data.isEmpty()) {
            return PropertySource.of(Collections.emptyMap());
        }
        Map.Entry entry = data.entrySet().iterator().next();
        if (data.size() > 1 || !KubernetesUtils.getExtension((String)entry.getKey()).isPresent()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Considering this ConfigMap as containing multiple literal key/values");
            }
            data.putIfAbsent("configMapResourceVersion", configMap.getMetadata().getResourceVersion());
            HashMap propertySourceData = new HashMap(data);
            return PropertySource.of((String)name, propertySourceData);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Considering this ConfigMap as containing values from a single file");
        }
        String extension = KubernetesUtils.getExtension((String)entry.getKey()).get();
        int priority = -100;
        PropertySource propertySource = PROPERTY_SOURCE_READERS.stream().filter(reader -> reader.getExtensions().contains(extension)).map(reader -> reader.read((String)entry.getKey(), ((String)entry.getValue()).getBytes())).peek(map -> map.putIfAbsent("configMapResourceVersion", configMap.getMetadata().getResourceVersion())).map(map -> PropertySource.of((String)((String)entry.getKey() + " (Kubernetes ConfigMap)"), (Map)map, (int)priority)).findFirst().orElse(PropertySource.of(Collections.emptyMap()));
        KubernetesConfigurationClient.addPropertySourceToCache(propertySource);
        return propertySource;
    }

    public static List<PropertySource> configMapAsPropertySource(String mountPoint, Map<String, String> data) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating {} PropertySources for ConfigMap mounted at: {}", (Object)data.size(), (Object)mountPoint);
        }
        if (data == null || data.isEmpty()) {
            return Collections.singletonList(PropertySource.of(Collections.emptyMap()));
        }
        ArrayList<PropertySource> propertySources = new ArrayList<PropertySource>(data.size());
        for (Map.Entry<String, String> entry : data.entrySet()) {
            Optional<String> extension = KubernetesUtils.getExtension(entry.getKey());
            if (!extension.isPresent()) {
                if (!LOG.isInfoEnabled()) continue;
                LOG.info("Failed to deduce the extension for file: {}", (Object)entry.getKey());
                continue;
            }
            String fileExtension = extension.get();
            String propertyName = mountPoint + "/" + entry.getKey() + " (Kubernetes ConfigMap)";
            int priority = -50;
            PropertySource propertySource = PROPERTY_SOURCE_READERS.stream().filter(reader -> reader.getExtensions().contains(fileExtension)).map(reader -> reader.read((String)entry.getKey(), ((String)entry.getValue()).getBytes())).map(map -> PropertySource.of((String)propertyName, (Map)map, (int)priority)).findFirst().orElse(PropertySource.of(Collections.emptyMap()));
            propertySources.add(propertySource);
        }
        return propertySources;
    }

    public static String computeLabelSelector(Map<String, String> labels) {
        String labelSelector = "";
        if (!labels.isEmpty()) {
            labelSelector = labels.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(","));
            if (LOG.isTraceEnabled()) {
                LOG.trace("labelSelector: {}", (Object)labelSelector);
            }
        }
        return labelSelector;
    }

    public static PropertySource secretAsPropertySource(V1Secret secret) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing PropertySources for Secret: {}", (Object)secret);
        }
        String name = secret.getMetadata().getName() + " (Kubernetes Secret)";
        Map data = secret.getData();
        Map<Object, Object> propertySourceData = null;
        propertySourceData = data != null ? data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> new String((byte[])v.getValue()))) : Collections.emptyMap();
        int priority = -100;
        PropertySource propertySource = PropertySource.of((String)name, propertySourceData, (int)priority);
        KubernetesConfigurationClient.addPropertySourceToCache(propertySource);
        return propertySource;
    }

    public static Predicate<KubernetesObject> getIncludesFilter(Collection<String> includes) {
        Predicate<KubernetesObject> includesFilter = s -> true;
        if (!includes.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Includes: {}", includes);
            }
            includesFilter = s -> {
                boolean result = includes.contains(s.getMetadata().getName());
                if (LOG.isTraceEnabled()) {
                    if (result) {
                        LOG.trace("Includes filter matched: {}", (Object)s.getMetadata().getName());
                    } else {
                        LOG.trace("Includes filter not-matched: {}", (Object)s.getMetadata().getName());
                    }
                }
                return result;
            };
        }
        return includesFilter;
    }

    public static Predicate<KubernetesObject> getExcludesFilter(Collection<String> excludes) {
        Predicate<KubernetesObject> excludesFilter = s -> true;
        if (!excludes.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Excludes: {}", excludes);
            }
            excludesFilter = s -> {
                boolean result;
                boolean bl = result = !excludes.contains(s.getMetadata().getName());
                if (LOG.isTraceEnabled()) {
                    if (result) {
                        LOG.trace("Excludes matched: {}", (Object)s.getMetadata().getName());
                    } else {
                        LOG.trace("Excludes filter not-matched: {}", (Object)s.getMetadata().getName());
                    }
                }
                return result;
            };
        }
        return excludesFilter;
    }

    public static Predicate<KubernetesObject> getLabelsFilter(Map<String, String> labels) {
        Predicate<KubernetesObject> labelsFilter = s -> true;
        if (!labels.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Filter labels: {}", labels.keySet());
            }
            labelsFilter = kubernetesObject -> {
                Map kubernetesObjectLabels = kubernetesObject.getMetadata().getLabels();
                boolean result = labels.entrySet().stream().allMatch(e -> kubernetesObjectLabels.containsKey(e.getKey()) && ((String)kubernetesObjectLabels.get(e.getKey())).equals(e.getValue()));
                if (LOG.isTraceEnabled()) {
                    if (result) {
                        LOG.trace("Filter labels filter matched: {}", (Object)kubernetesObject.getMetadata().getName());
                    } else {
                        LOG.trace("Filter labels not-matched: {}", (Object)kubernetesObject.getMetadata().getName());
                    }
                }
                return result;
            };
        }
        return labelsFilter;
    }

    public static Mono<String> computePodLabelSelector(CoreV1ApiReactorClient client, List<String> podLabelKeys, String namespace, Map<String, String> labels, boolean exceptionOnPodLabelsMissing) {
        String host = System.getenv(ENV_KUBERNETES_SERVICE_HOST);
        if (host == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not running on k8s");
            }
            return Mono.just((Object)KubernetesUtils.computeLabelSelector(labels));
        }
        String podName = System.getenv("HOSTNAME");
        return client.readNamespacedPod(podName, namespace, null, null, null).doOnError(ApiException.class, throwable -> LOG.error("Failed to read the Pod [" + podName + "] the application is running in: " + throwable.getResponseBody(), (Throwable)throwable)).map(pod -> {
            HashMap<String, String> result = new HashMap<String, String>();
            Map podLabels = Objects.requireNonNull(pod.getMetadata()).getLabels();
            for (String key : podLabelKeys) {
                String value = (String)podLabels.get(key);
                if (value != null) {
                    result.put(key, value);
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("Including pod label: {}={}", (Object)key, (Object)value);
                    continue;
                }
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Pod metadata does not contain label: {}", (Object)key);
                }
                if (!exceptionOnPodLabelsMissing) continue;
                throw new ConfigurationException("Pod metadata does not contain label: " + key + " and the exception-on-pod-labels-missing property is set");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Computed pod label selectors {}", result);
            }
            result.putAll(labels);
            return KubernetesUtils.computeLabelSelector(result);
        }).doOnError(throwable -> LOG.error("Failed to compute the label selector [" + podLabelKeys + "] from the Pod [" + podName + "]: " + throwable.getMessage(), throwable));
    }

    private static String getPropertySourceName(V1ConfigMap configMap) {
        return configMap.getMetadata().getName() + " (Kubernetes ConfigMap)";
    }

    private static Optional<String> getExtension(String filename) {
        return Optional.of(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(".") + 1));
    }
}

