/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.discovery;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1EndpointPort;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ServicePort;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.kubernetes.KubernetesConfiguration;
import io.micronaut.kubernetes.discovery.KubernetesServiceConfiguration;
import io.micronaut.kubernetes.discovery.KubernetesServiceInstanceProvider;
import io.micronaut.kubernetes.util.KubernetesUtils;
import java.net.URI;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKubernetesServiceInstanceProvider
implements KubernetesServiceInstanceProvider {
    public static final String SECURE_LABEL = "secure";
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractKubernetesServiceInstanceProvider.class);

    protected static Predicate<KubernetesObject> discoveryConfigurationFilter(KubernetesConfiguration.KubernetesDiscoveryConfiguration discoveryConfiguration) {
        return AbstractKubernetesServiceInstanceProvider.compositePredicate(KubernetesUtils.getIncludesFilter(discoveryConfiguration.getIncludes()), KubernetesUtils.getExcludesFilter(discoveryConfiguration.getExcludes()), KubernetesUtils.getLabelsFilter(discoveryConfiguration.getLabels()));
    }

    protected static Predicate<KubernetesObject> serviceConfigurationDiscoveryFilter(KubernetesServiceConfiguration serviceConfiguration, KubernetesConfiguration.KubernetesDiscoveryConfiguration discoveryConfiguration) {
        Predicate<KubernetesObject> globalFilter = !serviceConfiguration.isManual() ? AbstractKubernetesServiceInstanceProvider.discoveryConfigurationFilter(discoveryConfiguration) : f -> true;
        return globalFilter;
    }

    public static ServiceInstance buildServiceInstance(String serviceId, @Nullable PortBinder servicePort, String address, V1ObjectMeta metadata) {
        boolean isSecure = servicePort != null && AbstractKubernetesServiceInstanceProvider.isPortSecure(servicePort) || AbstractKubernetesServiceInstanceProvider.isMetadataSecure(metadata);
        String scheme = isSecure ? "https://" : "http://";
        int portNumber = servicePort != null ? servicePort.getPort() : 80;
        URI uri = URI.create(scheme + address + ":" + portNumber);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Building ServiceInstance for serviceId [{}] and URI [{}] with metadata [{}]", new Object[]{serviceId, uri, metadata});
        }
        return ServiceInstance.builder((String)serviceId, (URI)uri).metadata(metadata.getLabels()).build();
    }

    public static boolean isPortSecure(PortBinder servicePort) {
        String port = String.valueOf(servicePort.getPort());
        return port.endsWith("443") || "https".equals(servicePort.getName());
    }

    public static boolean isMetadataSecure(V1ObjectMeta objectMeta) {
        if (objectMeta.getLabels() == null) {
            return false;
        }
        String secure = objectMeta.getLabels().getOrDefault(SECURE_LABEL, "false");
        return "true".equals(secure);
    }

    public static boolean hasValidPortConfiguration(@Nullable List<PortBinder> ports, KubernetesServiceConfiguration serviceConfiguration) {
        String name = serviceConfiguration.getName().orElse(null);
        if (name != null && ports != null && ports.size() > 1 && !serviceConfiguration.getPort().isPresent()) {
            LOG.debug("The resource [" + name + "] has multiple ports declared [" + ports.stream().map(PortBinder::getName).collect(Collectors.joining(",")) + "] if you want to to use it in micronaut you have to configure it manually.");
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static Predicate<KubernetesObject> compositePredicate(Predicate<KubernetesObject> ... predicates) {
        return s -> {
            for (Predicate p : predicates) {
                boolean test = p.test(s);
                if (test) continue;
                return false;
            }
            return true;
        };
    }

    public static class PortBinder {
        private final String name;
        private final int port;

        public PortBinder(String name, int port) {
            this.name = name;
            this.port = port;
        }

        public String getName() {
            return this.name;
        }

        public int getPort() {
            return this.port;
        }

        public static PortBinder fromServicePort(@Nullable V1ServicePort servicePort) {
            if (servicePort == null) {
                return null;
            }
            return new PortBinder(servicePort.getName(), servicePort.getPort());
        }

        public static PortBinder fromEndpointPort(@Nullable V1EndpointPort endpointPort) {
            if (endpointPort == null) {
                return null;
            }
            return new PortBinder(endpointPort.getName(), endpointPort.getPort());
        }
    }
}

