/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.discovery;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import jakarta.inject.Inject;
import java.util.Optional;

@EachProperty(value="kubernetes.client.discovery.services")
@BootstrapContextCompatible
public class KubernetesServiceConfiguration {
    public static final String NAME = "services";
    public static final String PREFIX = "kubernetes.client.discovery.services";
    private String serviceId;
    private String name;
    private String namespace;
    private String mode;
    private String port;
    private final boolean manual;

    @Inject
    public KubernetesServiceConfiguration(@Parameter String serviceId) {
        this(serviceId, null, null, null, null, true);
    }

    public KubernetesServiceConfiguration(String serviceId, boolean manual) {
        this(serviceId, null, null, null, null, manual);
    }

    public KubernetesServiceConfiguration(String serviceId, String name, String namespace) {
        this(serviceId, name, namespace, null, null, false);
    }

    public KubernetesServiceConfiguration(String serviceId, String name, String namespace, String mode, String port, boolean manual) {
        this.serviceId = serviceId;
        this.name = name;
        this.namespace = namespace;
        this.mode = mode;
        this.port = port;
        this.manual = manual;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public Optional<String> getNamespace() {
        return Optional.ofNullable(this.namespace);
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Optional<String> getMode() {
        return Optional.ofNullable(this.mode);
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Optional<String> getPort() {
        return Optional.ofNullable(this.port);
    }

    public void setPort(String port) {
        this.port = port;
    }

    public boolean isManual() {
        return this.manual;
    }

    public String toString() {
        return "KubernetesServiceConfiguration{serviceId='" + this.serviceId + '\'' + ", name='" + this.name + '\'' + ", namespace='" + this.namespace + '\'' + ", mode='" + this.mode + '\'' + ", port='" + this.port + '\'' + ", manual=" + this.manual + '}';
    }
}

