/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.discovery.informer;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.informer.cache.Indexer;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Internal
public class IndexerComposite<ApiType extends KubernetesObject> {
    private static final Logger LOG = LoggerFactory.getLogger(IndexerComposite.class);
    private final Map<String, Indexer<ApiType>> informerMap = Collections.synchronizedMap(new HashedMap());

    protected void add(String namespace, Indexer<ApiType> sharedIndexInformer) {
        this.informerMap.put(namespace, sharedIndexInformer);
    }

    public Mono<ApiType> getResource(@NonNull String name, @NonNull String namespace) {
        Indexer indexer = this.informerMap.getOrDefault(namespace, null);
        if (indexer == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Failed to find resource name {} in namespace {}, indexer is null.", (Object)name, (Object)namespace);
            }
            return Mono.empty();
        }
        Optional<KubernetesObject> resources = indexer.list().stream().filter(e -> {
            if (e.getMetadata() != null) {
                return Objects.equals(e.getMetadata().getName(), name);
            }
            return false;
        }).findFirst();
        return resources.map(Mono::just).orElseGet(Mono::empty);
    }

    public Flux<ApiType> getResources(@NonNull String namespace) {
        Indexer indexed = this.informerMap.getOrDefault(namespace, null);
        if (indexed == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Failed to find resources for namespace {}, indexer null", (Object)namespace);
            }
            return Flux.empty();
        }
        return Flux.fromIterable((Iterable)indexed.list());
    }
}

