/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.discovery.provider;

import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.kubernetes.KubernetesConfiguration;
import io.micronaut.kubernetes.discovery.AbstractKubernetesServiceInstanceProvider;
import io.micronaut.kubernetes.discovery.KubernetesServiceConfiguration;
import io.micronaut.kubernetes.util.KubernetesUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractV1EndpointsProvider
extends AbstractKubernetesServiceInstanceProvider {
    public static final String MODE = "endpoint";
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractV1EndpointsProvider.class);
    private final KubernetesConfiguration.KubernetesDiscoveryConfiguration discoveryConfiguration;

    public AbstractV1EndpointsProvider(KubernetesConfiguration.KubernetesDiscoveryConfiguration discoveryConfiguration) {
        this.discoveryConfiguration = discoveryConfiguration;
    }

    @Override
    public String getMode() {
        return MODE;
    }

    @Override
    public Publisher<String> getServiceIds(String namespace) {
        return this.listEndpoints(namespace).filter(AbstractV1EndpointsProvider.discoveryConfigurationFilter(this.discoveryConfiguration)).mapNotNull(KubernetesUtils::objectNameOrNull).filter(Objects::nonNull);
    }

    @Override
    public Publisher<List<ServiceInstance>> getInstances(KubernetesServiceConfiguration serviceConfiguration) {
        String serviceName = serviceConfiguration.getName().orElseThrow(() -> new IllegalArgumentException("KubernetesServiceConfiguration is missing service name."));
        String serviceNamespace = serviceConfiguration.getNamespace().orElseThrow(() -> new IllegalArgumentException("KubernetesServiceConfiguration is missing namespace."));
        AtomicReference metadata = new AtomicReference();
        return this.getEndpoints(serviceName, serviceNamespace).filter(AbstractV1EndpointsProvider.serviceConfigurationDiscoveryFilter(serviceConfiguration, this.discoveryConfiguration)).doOnNext(endpoints -> metadata.set(endpoints.getMetadata())).mapNotNull(V1Endpoints::getSubsets).flatMapIterable(Function.identity()).filter(subset -> AbstractV1EndpointsProvider.hasValidPortConfiguration(((List)Optional.ofNullable(subset.getPorts()).orElse(new ArrayList())).stream().map(AbstractKubernetesServiceInstanceProvider.PortBinder::fromEndpointPort).collect(Collectors.toList()), serviceConfiguration)).filter(subset -> subset.getAddresses() != null && !subset.getAddresses().isEmpty()).map(subset -> ((List)Optional.ofNullable(subset.getPorts()).orElse(new ArrayList())).stream().filter(port -> !serviceConfiguration.getPort().isPresent() || Objects.equals(port.getName(), serviceConfiguration.getPort().get())).flatMap(port -> subset.getAddresses().stream().map(address -> AbstractV1EndpointsProvider.buildServiceInstance(serviceConfiguration.getServiceId(), AbstractKubernetesServiceInstanceProvider.PortBinder.fromEndpointPort(port), address.getIp(), (V1ObjectMeta)metadata.get()))).collect(Collectors.toList())).onErrorResume(throwable -> {
            if (LOG.isErrorEnabled()) {
                LOG.error("Error while processing discovered endpoints [" + serviceName + "]", throwable);
            }
            return Flux.just(Collections.emptyList());
        }).defaultIfEmpty(new ArrayList());
    }

    public abstract Mono<V1Endpoints> getEndpoints(String var1, String var2);

    public abstract Flux<V1Endpoints> listEndpoints(String var1);
}

