/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.discovery.provider;

import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServicePort;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.kubernetes.KubernetesConfiguration;
import io.micronaut.kubernetes.discovery.AbstractKubernetesServiceInstanceProvider;
import io.micronaut.kubernetes.discovery.KubernetesServiceConfiguration;
import io.micronaut.kubernetes.util.KubernetesUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractV1ServiceProvider
extends AbstractKubernetesServiceInstanceProvider {
    public static final String MODE = "service";
    protected static final String EXTERNAL_NAME = "ExternalName";
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractV1ServiceProvider.class);
    private final KubernetesConfiguration.KubernetesDiscoveryConfiguration discoveryConfiguration;

    protected AbstractV1ServiceProvider(KubernetesConfiguration.KubernetesDiscoveryConfiguration discoveryConfiguration) {
        this.discoveryConfiguration = discoveryConfiguration;
    }

    @Override
    public String getMode() {
        return MODE;
    }

    @Override
    public Publisher<List<ServiceInstance>> getInstances(KubernetesServiceConfiguration serviceConfiguration) {
        String serviceName = serviceConfiguration.getName().orElseThrow(() -> new IllegalArgumentException("KubernetesServiceConfiguration is missing name."));
        String serviceNamespace = serviceConfiguration.getNamespace().orElseThrow(() -> new IllegalArgumentException("KubernetesServiceConfiguration is missing namespace."));
        return this.getService(serviceName, serviceNamespace).filter(AbstractV1ServiceProvider.serviceConfigurationDiscoveryFilter(serviceConfiguration, this.discoveryConfiguration)).filter(service -> AbstractV1ServiceProvider.hasValidPortConfiguration(((List)Optional.ofNullable(Objects.requireNonNull(service.getSpec()).getPorts()).orElse(new ArrayList())).stream().map(AbstractKubernetesServiceInstanceProvider.PortBinder::fromServicePort).collect(Collectors.toList()), serviceConfiguration)).map(service -> Stream.of(AbstractV1ServiceProvider.buildServiceInstance(serviceConfiguration, service)).filter(Objects::nonNull).collect(Collectors.toList())).doOnError(throwable -> {
            if (LOG.isErrorEnabled()) {
                LOG.error("Error while processing discovered Service [" + serviceConfiguration.getName() + "]", throwable);
            }
        }).onErrorReturn(Collections.emptyList()).defaultIfEmpty(new ArrayList());
    }

    @Override
    public Publisher<String> getServiceIds(String namespace) {
        return this.listServices(namespace).filter(AbstractV1ServiceProvider.discoveryConfigurationFilter(this.discoveryConfiguration)).mapNotNull(KubernetesUtils::objectNameOrNull).filter(Objects::nonNull);
    }

    private static ServiceInstance buildServiceInstance(KubernetesServiceConfiguration serviceConfiguration, V1Service service) {
        String clusterIp = Objects.requireNonNull(service.getSpec()).getClusterIP();
        if (clusterIp != null && !Objects.equals(clusterIp, "None")) {
            return Objects.requireNonNull(service.getSpec().getPorts()).stream().filter(port -> !serviceConfiguration.getPort().isPresent() || Objects.equals(port.getName(), serviceConfiguration.getPort().get())).map(port -> AbstractV1ServiceProvider.buildServiceInstance(serviceConfiguration.getServiceId(), AbstractKubernetesServiceInstanceProvider.PortBinder.fromServicePort(port), service.getSpec().getClusterIP(), service.getMetadata())).findFirst().orElse(null);
        }
        if (Objects.equals(service.getSpec().getType(), EXTERNAL_NAME)) {
            List ports = service.getSpec().getPorts();
            V1ServicePort port2 = null;
            if (ports != null && !ports.isEmpty() && (port2 = (V1ServicePort)ports.stream().filter(p -> !serviceConfiguration.getPort().isPresent() || Objects.equals(p.getName(), serviceConfiguration.getPort().get())).findFirst().orElse(null)) == null) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Failed to assign ExternalName service [" + serviceConfiguration.getServiceId() + "] configured port " + serviceConfiguration.getPort().get() + ", no such port in specification [" + ports.stream().map(V1ServicePort::getName).collect(Collectors.joining(",")) + "]");
                }
                return null;
            }
            return AbstractV1ServiceProvider.buildServiceInstance(serviceConfiguration.getServiceId(), AbstractKubernetesServiceInstanceProvider.PortBinder.fromServicePort(port2), service.getSpec().getExternalName(), service.getMetadata());
        }
        if (LOG.isErrorEnabled()) {
            LOG.error("Failed to create service instance for [" + serviceConfiguration.getServiceId() + "]");
        }
        return null;
    }

    public abstract Mono<V1Service> getService(String var1, String var2);

    public abstract Flux<V1Service> listServices(String var1);
}

