/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.discovery.provider;

import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1EndpointsList;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.KubernetesConfiguration;
import io.micronaut.kubernetes.discovery.informer.IndexerComposite;
import io.micronaut.kubernetes.discovery.informer.IndexerCompositeFactory;
import io.micronaut.kubernetes.discovery.informer.InstanceProviderInformerNamespaceResolver;
import io.micronaut.kubernetes.discovery.provider.AbstractV1EndpointsProvider;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Requires(property="kubernetes.client.discovery.mode-configuration.endpoint.watch.enabled", notEquals="false", defaultValue="false")
@Singleton
public class KubernetesServiceInstanceEndpointInformerProvider
extends AbstractV1EndpointsProvider {
    protected static final String RESOURCE_PLURAL = "endpoints";
    protected static final Logger LOG = LoggerFactory.getLogger(KubernetesServiceInstanceEndpointInformerProvider.class);
    private IndexerComposite<V1Endpoints> indexerComposite;

    public KubernetesServiceInstanceEndpointInformerProvider(KubernetesConfiguration.KubernetesDiscoveryConfiguration discoveryConfiguration, InstanceProviderInformerNamespaceResolver informerNamespaceResolver, IndexerCompositeFactory indexerCompositeFactory) {
        super(discoveryConfiguration);
        this.indexerComposite = indexerCompositeFactory.createInformersFor(V1Endpoints.class, V1EndpointsList.class, RESOURCE_PLURAL, informerNamespaceResolver.resolveInformerNamespaces(this));
    }

    @Override
    public Mono<V1Endpoints> getEndpoints(String name, String namespace) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using Indexer to fetch Endpoints[{}] from namespace [{}]", (Object)name, (Object)namespace);
        }
        return this.indexerComposite.getResource(name, namespace);
    }

    @Override
    public Flux<V1Endpoints> listEndpoints(String namespace) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using Indexer to fetch endpoints from namespace [{}]", (Object)namespace);
        }
        return this.indexerComposite.getResources(namespace);
    }
}

