/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.discovery.provider;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1EndpointsList;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.KubernetesConfiguration;
import io.micronaut.kubernetes.client.reactor.CoreV1ApiReactorClient;
import io.micronaut.kubernetes.discovery.provider.AbstractV1EndpointsProvider;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Requires(property="kubernetes.client.discovery.mode-configuration.endpoint.watch.enabled", notEquals="true", defaultValue="false")
@Singleton
public class KubernetesServiceInstanceEndpointProvider
extends AbstractV1EndpointsProvider {
    protected static final Logger LOG = LoggerFactory.getLogger(KubernetesServiceInstanceEndpointProvider.class);
    private final CoreV1ApiReactorClient client;

    public KubernetesServiceInstanceEndpointProvider(CoreV1ApiReactorClient client, KubernetesConfiguration.KubernetesDiscoveryConfiguration discoveryConfiguration) {
        super(discoveryConfiguration);
        this.client = client;
    }

    @Override
    public Mono<V1Endpoints> getEndpoints(String name, String namespace) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using API to fetch Endpoints[{}] from namespace [{}]", (Object)name, (Object)namespace);
        }
        return this.client.readNamespacedEndpoints(name, namespace, null, null, null).doOnError(ApiException.class, throwable -> LOG.error("Failed to list Endpoints [ " + name + "] from namespace [" + namespace + "]: " + throwable.getResponseBody(), (Throwable)throwable));
    }

    @Override
    public Flux<V1Endpoints> listEndpoints(String namespace) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using API to fetch endpoints from namespace [{}]", (Object)namespace);
        }
        return this.client.listNamespacedEndpoints(namespace, null, null, null, null, null, null, null, null, null).doOnError(ApiException.class, throwable -> LOG.error("Failed to list Endpoints from namespace [" + namespace + "]: " + throwable.getResponseBody(), (Throwable)throwable)).flatMapIterable(V1EndpointsList::getItems);
    }
}

