/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.discovery.provider;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.KubernetesConfiguration;
import io.micronaut.kubernetes.client.reactor.CoreV1ApiReactorClient;
import io.micronaut.kubernetes.discovery.provider.AbstractV1ServiceProvider;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Requires(property="kubernetes.client.discovery.mode-configuration.service.watch.enabled", notEquals="true", defaultValue="false")
@Singleton
public class KubernetesServiceInstanceServiceProvider
extends AbstractV1ServiceProvider {
    protected static final Logger LOG = LoggerFactory.getLogger(KubernetesServiceInstanceServiceProvider.class);
    private final CoreV1ApiReactorClient client;

    public KubernetesServiceInstanceServiceProvider(CoreV1ApiReactorClient client, KubernetesConfiguration.KubernetesDiscoveryConfiguration discoveryConfiguration) {
        super(discoveryConfiguration);
        this.client = client;
    }

    @Override
    public Mono<V1Service> getService(String name, String namespace) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using API to fetch Service[{}] from namespace [{}]", (Object)name, (Object)namespace);
        }
        return this.client.readNamespacedService(name, namespace, null, null, null).doOnError(ApiException.class, throwable -> LOG.error("Failed to fetch Service [" + name + "] from namespace [" + namespace + "]: " + throwable.getResponseBody(), (Throwable)throwable));
    }

    @Override
    public Flux<V1Service> listServices(String namespace) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using API to fetch services from namespace [{}]", (Object)namespace);
        }
        return this.client.listNamespacedService(namespace, null, null, null, null, null, null, null, null, null).doOnError(ApiException.class, throwable -> LOG.error("Failed to list Services from namespace [" + namespace + "]: " + throwable.getResponseBody(), (Throwable)throwable)).flatMapIterable(V1ServiceList::getItems);
    }
}

