/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.discovery.DiscoveryConfiguration;
import io.micronaut.kubernetes.client.NamespaceResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Requires(env={"k8s"})
@ConfigurationProperties(value="kubernetes.client")
@BootstrapContextCompatible
public class KubernetesConfiguration {
    public static final String PREFIX = "kubernetes.client";
    private String namespace;
    private KubernetesDiscoveryConfiguration discovery = new KubernetesDiscoveryConfiguration();
    private KubernetesSecretsConfiguration secrets = new KubernetesSecretsConfiguration();
    private KubernetesConfigMapsConfiguration configMaps = new KubernetesConfigMapsConfiguration();

    public KubernetesConfiguration(NamespaceResolver namespaceResolver) {
        this.namespace = namespaceResolver.resolveNamespace();
    }

    @NonNull
    public KubernetesDiscoveryConfiguration getDiscovery() {
        return this.discovery;
    }

    public void setDiscovery(KubernetesDiscoveryConfiguration discoveryConfiguration) {
        this.discovery = discoveryConfiguration;
    }

    @NonNull
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @NonNull
    public KubernetesSecretsConfiguration getSecrets() {
        return this.secrets;
    }

    public void setSecrets(KubernetesSecretsConfiguration secretsConfiguration) {
        this.secrets = secretsConfiguration;
    }

    @NonNull
    public KubernetesConfigMapsConfiguration getConfigMaps() {
        return this.configMaps;
    }

    public void setConfigMaps(KubernetesConfigMapsConfiguration configMapsConfiguration) {
        this.configMaps = configMapsConfiguration;
    }

    public String toString() {
        return "KubernetesConfiguration{namespace='" + this.namespace + '\'' + ", discovery=" + (Object)((Object)this.discovery) + ", secrets=" + (Object)((Object)this.secrets) + ", configMaps=" + (Object)((Object)this.configMaps) + '}';
    }

    @ConfigurationProperties(value="config-maps")
    @BootstrapContextCompatible
    public static class KubernetesConfigMapsConfiguration
    extends AbstractKubernetesConfiguration {
        public static final String PREFIX = "config-maps";
        static final boolean DEFAULT_WATCH = true;
        private Collection<String> paths;
        private boolean useApi;
        private boolean watch = true;

        public Collection<String> getPaths() {
            if (this.paths == null) {
                return Collections.emptySet();
            }
            return this.paths;
        }

        public void setPaths(Collection<String> paths) {
            this.paths = paths;
        }

        public boolean isUseApi() {
            return this.useApi;
        }

        public void setUseApi(boolean useApi) {
            this.useApi = useApi;
        }

        public boolean isWatch() {
            return this.watch;
        }

        public void setWatch(boolean watch) {
            this.watch = watch;
        }
    }

    @ConfigurationProperties(value="secrets")
    @BootstrapContextCompatible
    public static class KubernetesSecretsConfiguration
    extends AbstractKubernetesConfiguration {
        static final String PREFIX = "secrets";
        static final boolean DEFAULT_ENABLED = false;
        private boolean enabled = false;
        private Collection<String> paths;
        private boolean useApi;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Collection<String> getPaths() {
            if (this.paths == null) {
                return Collections.emptySet();
            }
            return this.paths;
        }

        public void setPaths(Collection<String> paths) {
            this.paths = paths;
        }

        public boolean isUseApi() {
            return this.useApi;
        }

        public void setUseApi(boolean useApi) {
            this.useApi = useApi;
        }
    }

    private static abstract class AbstractKubernetesConfiguration
    extends DiscoveryConfiguration {
        private static final Boolean DEFAULT_EXCEPTION_ON_POD_LABELS_MISSING = false;
        private Collection<String> includes = new HashSet<String>();
        private Collection<String> excludes = new HashSet<String>();
        private Map<String, String> labels;
        private List<String> podLabels;
        private boolean exceptionOnPodLabelsMissing = DEFAULT_EXCEPTION_ON_POD_LABELS_MISSING;

        private AbstractKubernetesConfiguration() {
        }

        public Collection<String> getIncludes() {
            return this.includes;
        }

        public void setIncludes(Collection<String> includes) {
            this.includes = includes;
        }

        public Collection<String> getExcludes() {
            return this.excludes;
        }

        public void setExcludes(Collection<String> excludes) {
            this.excludes = excludes;
        }

        public Map<String, String> getLabels() {
            if (this.labels == null) {
                return Collections.emptyMap();
            }
            return this.labels;
        }

        public void setLabels(Map<String, String> labels) {
            this.labels = labels;
        }

        public List<String> getPodLabels() {
            if (this.podLabels == null) {
                return Collections.emptyList();
            }
            return this.podLabels;
        }

        public void setPodLabels(List<String> podLabels) {
            this.podLabels = podLabels;
        }

        public boolean isExceptionOnPodLabelsMissing() {
            return this.exceptionOnPodLabelsMissing;
        }

        public void setExceptionOnPodLabelsMissing(boolean exceptionOnPodLabelsMissing) {
            this.exceptionOnPodLabelsMissing = exceptionOnPodLabelsMissing;
        }
    }

    @ConfigurationProperties(value="discovery")
    @BootstrapContextCompatible
    public static class KubernetesDiscoveryConfiguration
    extends AbstractKubernetesConfiguration {
        public static final String DEFAULT_MODE = "endpoint";
        public static final String PREFIX = "kubernetes.client.discovery";
        private String mode = "endpoint";

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }
    }
}

