/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.configuration;

import io.micronaut.kubernetes.KubernetesConfiguration;
import io.micronaut.kubernetes.client.reactor.CoreV1ApiReactorClient;
import io.micronaut.kubernetes.util.KubernetesUtils;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConfigMapLabelSupplier
implements Supplier<String> {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigMapLabelSupplier.class);
    private final CoreV1ApiReactorClient coreV1ApiReactorClient;
    private final KubernetesConfiguration configuration;

    public ConfigMapLabelSupplier(CoreV1ApiReactorClient coreV1ApiReactorClient, KubernetesConfiguration configuration) {
        this.coreV1ApiReactorClient = coreV1ApiReactorClient;
        this.configuration = configuration;
    }

    @Override
    public String get() {
        Map labels = this.configuration.getConfigMaps().getLabels();
        String labelSelector = (String)KubernetesUtils.computePodLabelSelector(this.coreV1ApiReactorClient, this.configuration.getConfigMaps().getPodLabels(), this.configuration.getNamespace(), labels, this.configuration.getDiscovery().isExceptionOnPodLabelsMissing()).block();
        if (LOG.isInfoEnabled()) {
            LOG.info("Computed kubernetes configuration discovery config map label selector: {}", (Object)labelSelector);
        }
        return labelSelector;
    }
}

