/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.configuration;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.V1ConfigMapList;
import io.kubernetes.client.openapi.models.V1ConfigMapListBuilder;
import io.kubernetes.client.openapi.models.V1SecretList;
import io.kubernetes.client.openapi.models.V1SecretListBuilder;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.discovery.config.ConfigurationClient;
import io.micronaut.kubernetes.KubernetesConfiguration;
import io.micronaut.kubernetes.client.reactor.CoreV1ApiReactorClient;
import io.micronaut.kubernetes.util.KubernetesUtils;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Singleton
@Requirements(value={@Requires(env={"k8s"}), @Requires(property="micronaut.config-client.enabled", value="true", defaultValue="false")})
@BootstrapContextCompatible
public class KubernetesConfigurationClient
implements ConfigurationClient {
    public static final String CONFIG_MAP_LIST_RESOURCE_VERSION = "configMapListResourceVersion";
    public static final String CONFIG_MAP_RESOURCE_VERSION = "configMapResourceVersion";
    public static final String KUBERNETES_CONFIG_MAP_LIST_NAME = "Kubernetes ConfigMapList";
    public static final String KUBERNETES_CONFIG_MAP_NAME_SUFFIX = " (Kubernetes ConfigMap)";
    public static final String KUBERNETES_SECRET_NAME_SUFFIX = " (Kubernetes Secret)";
    public static final String OPAQUE_SECRET_TYPE = "Opaque";
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesConfigurationClient.class);
    private static Map<String, PropertySource> propertySources = new ConcurrentHashMap<String, PropertySource>();
    private final CoreV1ApiReactorClient client;
    private final KubernetesConfiguration configuration;

    public KubernetesConfigurationClient(CoreV1ApiReactorClient client, KubernetesConfiguration configuration) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing {}", (Object)this.getClass().getName());
        }
        this.client = client;
        this.configuration = configuration;
    }

    public Publisher<PropertySource> getPropertySources(Environment environment) {
        if (!propertySources.isEmpty()) {
            LOG.trace("Found cached PropertySources. Returning them");
            return Flux.fromIterable(propertySources.values());
        }
        LOG.trace("PropertySource cache is empty");
        return Flux.from(this.getPropertySourcesFromConfigMaps()).mergeWith(this.getPropertySourcesFromSecrets());
    }

    @NonNull
    public String getDescription() {
        return "kubernetes";
    }

    public static void addPropertySourceToCache(PropertySource propertySource) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Adding property source {} to cache", (Object)propertySource.getName());
        }
        propertySources.put(propertySource.getName(), propertySource);
    }

    static void removePropertySourceFromCache(String name) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Removing property source {} from cache", (Object)name);
        }
        propertySources.remove(name);
    }

    static Map<String, PropertySource> getPropertySourceCache() {
        return propertySources;
    }

    private Flux<PropertySource> getPropertySourcesFromConfigMaps() {
        Flux propertySourceFlux = Flux.empty();
        KubernetesConfiguration.KubernetesConfigMapsConfiguration configMapsConfiguration = this.configuration.getConfigMaps();
        if (configMapsConfiguration.isEnabled()) {
            Collection<String> mountedVolumePaths = configMapsConfiguration.getPaths();
            if (mountedVolumePaths.isEmpty() || configMapsConfiguration.isUseApi()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reading ConfigMaps from the Kubernetes API");
                }
                Predicate<KubernetesObject> includesFilter = KubernetesUtils.getIncludesFilter(configMapsConfiguration.getIncludes());
                Predicate<KubernetesObject> excludesFilter = KubernetesUtils.getExcludesFilter(configMapsConfiguration.getExcludes());
                Map labels = configMapsConfiguration.getLabels();
                boolean exceptionOnPodLabelsMissing = this.configuration.getConfigMaps().isExceptionOnPodLabelsMissing();
                Flux configMapListFlux = KubernetesUtils.computePodLabelSelector(this.client, this.configuration.getConfigMaps().getPodLabels(), this.configuration.getNamespace(), labels, exceptionOnPodLabelsMissing).doOnError(throwable -> LOG.error("Failed to compute pod label selector: " + throwable.getMessage(), throwable)).doOnNext(labelSelector -> {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Going to list ConfigMaps from namespace [{}] with label selector [{}]", (Object)this.configuration.getNamespace(), labelSelector);
                    }
                }).flatMap(labelSelector -> this.client.listNamespacedConfigMap(this.configuration.getNamespace(), null, null, null, null, labelSelector, null, null, null, null)).doOnError(ApiException.class, throwable -> LOG.error("Error to list ConfigMaps in the namespace [" + this.configuration.getNamespace() + "]: " + throwable.getResponseBody(), (Throwable)throwable)).onErrorResume(throwable -> exceptionOnPodLabelsMissing ? Mono.error((Throwable)throwable) : Mono.just((Object)((V1ConfigMapListBuilder)new V1ConfigMapListBuilder().withItems(new ArrayList())).build())).doOnNext(configMapList -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found {} config maps. Applying includes/excludes filters (if any)", (Object)configMapList.getItems().size());
                    }
                }).flux().flatMap(configMapList -> Flux.merge((Publisher[])new Publisher[]{Flux.just((Object)KubernetesConfigurationClient.configMapListAsPropertySource(configMapList)), Flux.fromIterable((Iterable)configMapList.getItems()).filter(includesFilter).filter(excludesFilter).doOnNext(configMap -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding config map with name {}", (Object)configMap.getMetadata().getName());
                    }
                }).map(KubernetesUtils::configMapAsPropertySource)}));
                propertySourceFlux = propertySourceFlux.mergeWith((Publisher)configMapListFlux);
            }
            if (!mountedVolumePaths.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reading ConfigMaps from the following mounted volumes: {}", mountedVolumePaths);
                }
                ArrayList propertySources = new ArrayList();
                mountedVolumePaths.stream().map(x$0 -> Paths.get(x$0, new String[0])).forEach(path -> {
                    HashMap<String, String> configMapFiles;
                    block20: {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Processing ConfigMap mounted on path: {}", path);
                        }
                        configMapFiles = new HashMap<String, String>();
                        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                            for (Path file : stream) {
                                String fileName = file.getFileName().toString();
                                String absolutePath = path + "/" + fileName;
                                if (!Files.isRegularFile(file, new LinkOption[0])) {
                                    if (!LOG.isTraceEnabled()) continue;
                                    LOG.trace("Skipping not regular file: {}", (Object)absolutePath);
                                    continue;
                                }
                                String value = new String(Files.readAllBytes(file));
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace("Found file: {}", (Object)absolutePath);
                                }
                                configMapFiles.put(fileName, value);
                            }
                        }
                        catch (IOException e) {
                            if (!LOG.isWarnEnabled()) break block20;
                            LOG.warn("Exception occurred when reading configmap from path: {}", path);
                            LOG.warn(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Property sources found on path '{}': {}", path, configMapFiles.keySet());
                    }
                    if (!configMapFiles.isEmpty()) {
                        List<PropertySource> mountedMapPropertySources = KubernetesUtils.configMapAsPropertySource(path.toString(), configMapFiles);
                        mountedMapPropertySources.forEach(KubernetesConfigurationClient::addPropertySourceToCache);
                        propertySources.addAll(mountedMapPropertySources);
                    }
                });
                propertySourceFlux = propertySourceFlux.mergeWith((Publisher)Flux.fromIterable(propertySources));
            }
        }
        return propertySourceFlux;
    }

    private static PropertySource configMapListAsPropertySource(V1ConfigMapList configMapList) {
        String resourceVersion;
        String string = resourceVersion = configMapList.getMetadata() != null ? configMapList.getMetadata().getResourceVersion() : "-1";
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding config map list with version {}", (Object)resourceVersion);
        }
        return PropertySource.of((String)KUBERNETES_CONFIG_MAP_LIST_NAME, Collections.singletonMap(CONFIG_MAP_LIST_RESOURCE_VERSION, resourceVersion), (int)-100);
    }

    private Publisher<PropertySource> getPropertySourcesFromSecrets() {
        Flux propertySourceFlowable = Flux.empty();
        if (this.configuration.getSecrets().isEnabled()) {
            Collection<String> mountedVolumePaths = this.configuration.getSecrets().getPaths();
            if (mountedVolumePaths.isEmpty() || this.configuration.getSecrets().isUseApi()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reading Secrets from the Kubernetes API");
                }
                Predicate<KubernetesObject> includesFilter = KubernetesUtils.getIncludesFilter(this.configuration.getSecrets().getIncludes());
                Predicate<KubernetesObject> excludesFilter = KubernetesUtils.getExcludesFilter(this.configuration.getSecrets().getExcludes());
                Map labels = this.configuration.getSecrets().getLabels();
                boolean exceptionOnPodLabelsMissing = this.configuration.getSecrets().isExceptionOnPodLabelsMissing();
                Flux secretListFlowable = KubernetesUtils.computePodLabelSelector(this.client, this.configuration.getSecrets().getPodLabels(), this.configuration.getNamespace(), labels, exceptionOnPodLabelsMissing).flatMap(labelSelector -> this.client.listNamespacedSecret(this.configuration.getNamespace(), null, null, null, null, labelSelector, null, null, null, null)).doOnError(ApiException.class, throwable -> LOG.error("Failed to list Secrets in the namespace [" + this.configuration.getNamespace() + "]: " + throwable.getResponseBody(), (Throwable)throwable)).onErrorResume(throwable -> exceptionOnPodLabelsMissing ? Mono.error((Throwable)throwable) : Mono.just((Object)((V1SecretListBuilder)new V1SecretListBuilder().withItems(new ArrayList())).build())).doOnNext(secretList -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found {} secrets. Filtering Opaque secrets and includes/excludes (if any)", (Object)secretList.getItems().size());
                    }
                }).flatMapIterable(V1SecretList::getItems).filter(secret -> Objects.equals(secret.getType(), OPAQUE_SECRET_TYPE)).filter(includesFilter).filter(excludesFilter).doOnNext(secret -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding secret with name {}", (Object)secret.getMetadata().getName());
                    }
                }).map(KubernetesUtils::secretAsPropertySource);
                propertySourceFlowable = propertySourceFlowable.mergeWith((Publisher)secretListFlowable);
            }
            if (!mountedVolumePaths.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reading Secrets from the following mounted volumes: {}", mountedVolumePaths);
                }
                ArrayList propertySources = new ArrayList();
                mountedVolumePaths.stream().map(x$0 -> Paths.get(x$0, new String[0])).forEach(path -> {
                    LOG.trace("Processing path: {}", path);
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                        HashMap<String, String> propertySourceContents = new HashMap<String, String>();
                        for (Path file : stream) {
                            if (Files.isDirectory(file, new LinkOption[0])) continue;
                            String key = file.getFileName().toString();
                            String value = new String(Files.readAllBytes(file));
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Processing key: {}", (Object)key);
                            }
                            propertySourceContents.put(key, value);
                        }
                        String propertySourceName = path.toString() + KUBERNETES_SECRET_NAME_SUFFIX;
                        int priority = -50;
                        PropertySource propertySource = PropertySource.of((String)propertySourceName, propertySourceContents, (int)priority);
                        KubernetesConfigurationClient.addPropertySourceToCache(propertySource);
                        propertySources.add(propertySource);
                    }
                    catch (IOException e) {
                        LOG.warn("Exception occurred when reading secrets from path: {}", path);
                        LOG.warn(e.getMessage(), (Throwable)e);
                    }
                });
                propertySourceFlowable = propertySourceFlowable.mergeWith((Publisher)Flux.fromIterable(propertySources));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Kubernetes secrets access is disabled");
        }
        return propertySourceFlowable;
    }
}

