/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.discovery.informer;

import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.micronaut.core.annotation.Internal;
import io.micronaut.kubernetes.client.informer.SharedIndexInformerFactory;
import io.micronaut.kubernetes.discovery.informer.IndexerComposite;
import jakarta.inject.Singleton;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@Singleton
public class IndexerCompositeFactory {
    private static final Logger LOG = LoggerFactory.getLogger(IndexerCompositeFactory.class);
    private final SharedIndexInformerFactory sharedIndexInformerFactory;

    public IndexerCompositeFactory(SharedIndexInformerFactory sharedIndexInformerFactory) {
        this.sharedIndexInformerFactory = sharedIndexInformerFactory;
    }

    public <ApiType extends KubernetesObject> IndexerComposite<ApiType> createInformersFor(Class<ApiType> apiType, Class<? extends KubernetesListObject> apiListType, String resourcePlural, Set<String> namespaces) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Going to create Informers of type {} in the namespaces: {}", apiType, namespaces);
        }
        IndexerComposite indexerComposite = new IndexerComposite();
        for (String namespace : namespaces) {
            SharedIndexInformer informer = this.sharedIndexInformerFactory.sharedIndexInformerFor(apiType, apiListType, resourcePlural, "", namespace, null, null, true);
            indexerComposite.add(namespace, informer.getIndexer());
        }
        return indexerComposite;
    }
}

