/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.discovery.informer;

import io.micronaut.core.annotation.Internal;
import io.micronaut.kubernetes.KubernetesConfiguration;
import io.micronaut.kubernetes.discovery.KubernetesServiceConfiguration;
import io.micronaut.kubernetes.discovery.KubernetesServiceInstanceProvider;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Internal
@Singleton
public class InstanceProviderInformerNamespaceResolver {
    private final KubernetesConfiguration kubernetesConfiguration;
    private final KubernetesConfiguration.KubernetesDiscoveryConfiguration discoveryConfiguration;
    private final List<KubernetesServiceConfiguration> serviceConfigurations;

    public InstanceProviderInformerNamespaceResolver(KubernetesConfiguration kubernetesConfiguration, KubernetesConfiguration.KubernetesDiscoveryConfiguration discoveryConfiguration, List<KubernetesServiceConfiguration> serviceConfigurations) {
        this.kubernetesConfiguration = kubernetesConfiguration;
        this.discoveryConfiguration = discoveryConfiguration;
        this.serviceConfigurations = serviceConfigurations;
    }

    public Set<String> resolveInformerNamespaces(KubernetesServiceInstanceProvider kubernetesServiceInstanceProvider) {
        String mode = kubernetesServiceInstanceProvider.getMode();
        Set<String> namespaces = this.serviceConfigurations.stream().filter(s -> s.getMode().map(ns -> ns.equalsIgnoreCase(mode)).orElse(mode.equalsIgnoreCase(this.discoveryConfiguration.getMode()))).filter(s -> s.getNamespace().isPresent()).map(s -> s.getNamespace().get()).collect(Collectors.toSet());
        if (this.discoveryConfiguration.getMode().equalsIgnoreCase(mode)) {
            namespaces.add(this.kubernetesConfiguration.getNamespace());
        }
        return namespaces;
    }
}

