/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.discovery.provider;

import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.micronaut.context.annotation.Requires;
import io.micronaut.kubernetes.KubernetesConfiguration;
import io.micronaut.kubernetes.discovery.informer.IndexerComposite;
import io.micronaut.kubernetes.discovery.informer.IndexerCompositeFactory;
import io.micronaut.kubernetes.discovery.informer.InstanceProviderInformerNamespaceResolver;
import io.micronaut.kubernetes.discovery.provider.AbstractV1ServiceProvider;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Requires(property="kubernetes.client.discovery.mode-configuration.service.watch.enabled", notEquals="false", defaultValue="false")
@Singleton
public class KubernetesServiceInstanceServiceInformerProvider
extends AbstractV1ServiceProvider {
    protected static final String RESOURCE_PLURAL = "services";
    protected static final Logger LOG = LoggerFactory.getLogger(KubernetesServiceInstanceServiceInformerProvider.class);
    private final IndexerComposite<V1Service> indexerComposite;

    public KubernetesServiceInstanceServiceInformerProvider(KubernetesConfiguration.KubernetesDiscoveryConfiguration discoveryConfiguration, InstanceProviderInformerNamespaceResolver informerNamespaceResolver, IndexerCompositeFactory indexerCompositeFactory) {
        super(discoveryConfiguration);
        this.indexerComposite = indexerCompositeFactory.createInformersFor(V1Service.class, V1ServiceList.class, RESOURCE_PLURAL, informerNamespaceResolver.resolveInformerNamespaces(this));
    }

    @Override
    public Mono<V1Service> getService(String name, String namespace) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using Indexer to fetch Service[{}] from namespace [{}]", (Object)name, (Object)namespace);
        }
        return this.indexerComposite.getResource(name, namespace);
    }

    @Override
    public Flux<V1Service> listServices(String namespace) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using Indexer to fetch services from namespace [{}]", (Object)namespace);
        }
        return this.indexerComposite.getResources(namespace);
    }
}

