/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.informer;

import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.apimachinery.GroupVersionKind;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.informer.ListerWatcher;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.impl.DefaultSharedIndexInformer;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CustomObjectsApi;
import io.kubernetes.client.util.CallGeneratorParams;
import io.kubernetes.client.util.Watchable;
import io.kubernetes.client.util.generic.GenericKubernetesApi;
import io.kubernetes.client.util.generic.options.ListOptions;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.ModelMapper;
import io.micronaut.kubernetes.client.informer.InformerConfiguration;
import io.micronaut.kubernetes.client.informer.SharedIndexInformerFactory;
import jakarta.inject.Singleton;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(property="kubernetes.client.informer.enabled", notEquals="false", defaultValue="true")
@Singleton
public class DefaultSharedIndexInformerFactory
extends SharedInformerFactory
implements SharedIndexInformerFactory {
    public static final String INFORMER_ENABLED = "kubernetes.client.informer.enabled";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSharedIndexInformerFactory.class);
    private static final ModelMapper MAPPER = new ModelMapper();
    private final InformerConfiguration informerConfiguration;
    private final ApiClient apiClient;

    public DefaultSharedIndexInformerFactory(InformerConfiguration informerConfiguration, ApiClient apiClient) {
        this.apiClient = apiClient;
        this.informerConfiguration = informerConfiguration;
    }

    @Override
    public <ApiType extends KubernetesObject, ApiListType extends KubernetesListObject> SharedIndexInformer<ApiType> sharedIndexInformerFor(Class<ApiType> apiType, Class<ApiListType> apiListType, String resourcePlural, String apiGroup, @Nullable String namespace, @Nullable String labelSelector, @Nullable Long resyncCheckPeriod, boolean waitForSync) {
        String ns;
        Objects.requireNonNull(apiType, "apiType is required to create informer");
        Objects.requireNonNull(apiListType, "apiListType is required to create informer");
        Objects.requireNonNull(resourcePlural, "resourcePlural is required to create informer");
        Objects.requireNonNull(apiGroup, "apiGroup is required to create informer");
        GroupVersionKind groupVersionKind = MAPPER.getGroupVersionKindByClass(apiType);
        String version = groupVersionKind.getVersion();
        String string = ns = namespace == null ? "" : namespace;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating Informer for KubernetesObject '{}' with group '{}', version '{}', resource plural '{}', label selector '{}' and namespace '{}'", new Object[]{apiType, apiGroup, version, resourcePlural, labelSelector, namespace});
        }
        GenericKubernetesApi kubernetesApi = new GenericKubernetesApi(apiType, apiListType, apiGroup, version, resourcePlural, new CustomObjectsApi(this.apiClient));
        SharedIndexInformer<ApiType> informer = this.sharedIndexInformerFor(this.listerWatcherFor(kubernetesApi, labelSelector, ns), apiType, ns, resyncCheckPeriod == null ? 0L : resyncCheckPeriod);
        if (LOG.isInfoEnabled()) {
            LOG.info("Created Informer for '{}' in namespace '{}'", apiType, (Object)ns);
        }
        this.startAllRegisteredInformers();
        if (waitForSync) {
            Duration syncTimeout = Duration.ofSeconds(this.informerConfiguration.getSyncTimeout());
            Duration syncStep = Duration.ofMillis(this.informerConfiguration.getSyncStepTimeout());
            if (LOG.isInfoEnabled()) {
                LOG.info("Waiting for Informer<'{}'> in namespace '{}' to sync", apiType, (Object)namespace);
            }
            long waitLimit = System.currentTimeMillis() + syncTimeout.toMillis();
            while (waitLimit > System.currentTimeMillis() && !informer.hasSynced()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Waiting {} millis to let Informer<'{}'> in namespace '{}' to sync", new Object[]{syncStep.toMillis(), apiType, namespace});
                }
                try {
                    Thread.sleep(syncStep.toMillis());
                }
                catch (InterruptedException e) {
                    if (!LOG.isInfoEnabled()) break;
                    LOG.info("Active waiting for the Informer<'{}'> in namespace '{}' sync up interrupted. Cancelling waiting.", apiType, (Object)namespace);
                    break;
                }
            }
            boolean hasSynced = informer.hasSynced();
            if (LOG.isInfoEnabled() && hasSynced) {
                LOG.info("Informer<'{}'> in namespace '{}' synced up, {} resources in the store", new Object[]{apiType, namespace, informer.getIndexer().list().size()});
            }
            if (LOG.isWarnEnabled() && !hasSynced) {
                LOG.warn("Informer<'{}'> in namespace '{}' didn't sync up. The resources may not be available for the Informer resource event handler. Consider to raise the sync up timeout `kubernetes.client.informer.sync-timeout` configured now to {} seconds", new Object[]{apiType, namespace, this.informerConfiguration.getSyncTimeout()});
            }
        }
        return informer;
    }

    @Override
    public <ApiType extends KubernetesObject, ApiListType extends KubernetesListObject> List<SharedIndexInformer<? extends KubernetesObject>> sharedIndexInformersFor(Class<ApiType> apiTypeClass, Class<ApiListType> apiListTypeClass, String resourcePlural, String apiGroup, @Nullable List<String> namespaces, @Nullable String labelSelector, @Nullable Long resyncCheckPeriod, boolean waitForSync) {
        if (namespaces == null) {
            namespaces = Collections.singletonList("");
        }
        ArrayList<SharedIndexInformer<? extends KubernetesObject>> informers = new ArrayList<SharedIndexInformer<? extends KubernetesObject>>(namespaces.size());
        for (String namespace : namespaces) {
            SharedIndexInformer<ApiType> informer = this.sharedIndexInformerFor(apiTypeClass, apiListTypeClass, resourcePlural, apiGroup, namespace, labelSelector, resyncCheckPeriod, waitForSync);
            informers.add(informer);
        }
        return informers;
    }

    @Override
    public void stopAllRegisteredInformers() {
        super.stopAllRegisteredInformers(false);
    }

    @Override
    public <ApiType extends KubernetesObject> SharedIndexInformer<ApiType> getExistingSharedIndexInformer(String namespace, Class<ApiType> apiTypeClass) {
        NamespaceResourceClassType type = new NamespaceResourceClassType(namespace, apiTypeClass);
        return this.informers.getOrDefault(type, null);
    }

    @Override
    public List<SharedIndexInformer> getExistingSharedIndexInformers() {
        return new ArrayList<SharedIndexInformer>(this.informers.values());
    }

    private synchronized <ApiType extends KubernetesObject, ApiListType extends KubernetesListObject> SharedIndexInformer<ApiType> sharedIndexInformerFor(ListerWatcher<ApiType, ApiListType> listerWatcher, Class<ApiType> apiTypeClass, String namespace, long resyncPeriodInMillis) {
        DefaultSharedIndexInformer informer = new DefaultSharedIndexInformer(apiTypeClass, listerWatcher, resyncPeriodInMillis);
        NamespaceResourceClassType type = new NamespaceResourceClassType(namespace, apiTypeClass);
        this.informers.putIfAbsent(type, informer);
        return informer;
    }

    private <ApiType extends KubernetesObject, ApiListType extends KubernetesListObject> ListerWatcher<ApiType, ApiListType> listerWatcherFor(final GenericKubernetesApi<ApiType, ApiListType> genericKubernetesApi, final String labelSelector, final String namespace) {
        return new ListerWatcher<ApiType, ApiListType>(){

            public ApiListType list(CallGeneratorParams params) throws ApiException {
                ExtendedCallGeneratorParams generatorParams = new ExtendedCallGeneratorParams(params.watch, params.resourceVersion, params.timeoutSeconds, labelSelector);
                ListOptions options = DefaultSharedIndexInformerFactory.this.createListOptions(generatorParams);
                if ("".equals(namespace)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("List all namespaces with params: {}", (Object)generatorParams);
                    }
                    return (KubernetesListObject)genericKubernetesApi.list(options).throwsApiException().getObject();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("List namespace '{}' with params: {}", (Object)namespace, (Object)generatorParams);
                }
                return (KubernetesListObject)genericKubernetesApi.list(namespace, options).throwsApiException().getObject();
            }

            public Watchable<ApiType> watch(CallGeneratorParams params) throws ApiException {
                ExtendedCallGeneratorParams generatorParams = new ExtendedCallGeneratorParams(params.watch, params.resourceVersion, params.timeoutSeconds, labelSelector);
                ListOptions options = DefaultSharedIndexInformerFactory.this.createListOptions(generatorParams);
                if ("".equals(namespace)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Watch all namespaces with params: {}", (Object)generatorParams);
                    }
                    return genericKubernetesApi.watch(options);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Watch namespace '{}' with params: {}", (Object)namespace, (Object)generatorParams);
                }
                return genericKubernetesApi.watch(namespace, options);
            }
        };
    }

    private ListOptions createListOptions(final ExtendedCallGeneratorParams params) {
        return new ListOptions(){
            {
                this.setResourceVersion(params.resourceVersion);
                this.setTimeoutSeconds(params.timeoutSeconds);
                this.setLabelSelector(params.labelSelector);
            }
        };
    }

    static class NamespaceResourceClassType
    implements Type {
        String namespace;
        Class clazz;

        public NamespaceResourceClassType(String namespace, Class clazz) {
            this.namespace = namespace;
            this.clazz = clazz;
        }

        @Override
        public String getTypeName() {
            return this.namespace + "#" + TypeToken.get((Class)this.clazz).getType().getTypeName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamespaceResourceClassType that = (NamespaceResourceClassType)o;
            return this.namespace.equals(that.namespace) && this.clazz.equals(that.clazz);
        }

        public int hashCode() {
            return Objects.hash(this.namespace, this.clazz);
        }
    }

    static class ExtendedCallGeneratorParams
    extends CallGeneratorParams {
        String labelSelector;

        public ExtendedCallGeneratorParams(Boolean watch, String resourceVersion, Integer timeoutSeconds, String labelSelector) {
            super(watch, resourceVersion, timeoutSeconds);
            this.labelSelector = labelSelector;
        }

        public String toString() {
            return "ExtendedCallGeneratorParams{labelSelector='" + this.labelSelector + '\'' + ", watch=" + this.watch + ", resourceVersion='" + this.resourceVersion + '\'' + ", timeoutSeconds=" + this.timeoutSeconds + '}';
        }
    }
}

