/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.informer;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ShutdownEvent;
import io.micronaut.context.event.StartupEvent;
import io.micronaut.core.annotation.Internal;
import io.micronaut.kubernetes.client.informer.SharedIndexInformerFactory;
import io.micronaut.runtime.event.annotation.EventListener;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(beans={SharedIndexInformerFactory.class})
@Singleton
@Internal
public class InformerFactoryLifecycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(InformerFactoryLifecycleListener.class);
    private final SharedIndexInformerFactory sharedSharedIndexInformerFactory;

    public InformerFactoryLifecycleListener(SharedIndexInformerFactory sharedSharedIndexInformerFactory) {
        this.sharedSharedIndexInformerFactory = sharedSharedIndexInformerFactory;
    }

    @EventListener
    public void startInformerFactoryOnStartupEvent(StartupEvent startupEvent) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Starting shared informer factory");
        }
        this.sharedSharedIndexInformerFactory.startAllRegisteredInformers();
    }

    @EventListener
    public void shutdown(ShutdownEvent shutdownEvent) {
        if (LOG.isInfoEnabled()) {
            LOG.info("Closing shared informer factory on shutdown");
        }
        this.sharedSharedIndexInformerFactory.stopAllRegisteredInformers();
    }
}

