/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.informer;

import io.kubernetes.client.Discovery;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.informer.ResourceEventHandler;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.micronaut.aop.ConstructorInterceptor;
import io.micronaut.aop.ConstructorInvocationContext;
import io.micronaut.aop.InterceptorBean;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.kubernetes.client.DiscoveryCache;
import io.micronaut.kubernetes.client.NamespaceResolver;
import io.micronaut.kubernetes.client.informer.EmptyLabelSupplier;
import io.micronaut.kubernetes.client.informer.EmptyNamespacesSupplier;
import io.micronaut.kubernetes.client.informer.Informer;
import io.micronaut.kubernetes.client.informer.SharedIndexInformerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(beans={SharedInformerFactory.class})
@InterceptorBean(value={Informer.class})
@Internal
public class ResourceEventHandlerConstructorInterceptor<ApiType extends KubernetesObject>
implements ConstructorInterceptor<ResourceEventHandler<ApiType>> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceEventHandlerConstructorInterceptor.class);
    private final SharedIndexInformerFactory sharedIndexInformerFactory;
    private final NamespaceResolver namespaceResolver;
    private final ApplicationContext applicationContext;
    private final DiscoveryCache discoveryCache;

    public ResourceEventHandlerConstructorInterceptor(SharedIndexInformerFactory sharedIndexInformerFactory, NamespaceResolver namespaceResolver, ApplicationContext applicationContext, @Nullable DiscoveryCache discoveryCache) {
        this.sharedIndexInformerFactory = sharedIndexInformerFactory;
        this.namespaceResolver = namespaceResolver;
        this.applicationContext = applicationContext;
        this.discoveryCache = discoveryCache;
    }

    @NonNull
    public ResourceEventHandler<ApiType> intercept(@NonNull ConstructorInvocationContext<ResourceEventHandler<ApiType>> context) {
        Class declaringType = context.getDeclaringType();
        if (declaringType.isAnnotationPresent(Informer.class)) {
            String namespace;
            Informer typeAnnotation = declaringType.getAnnotation(Informer.class);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Found @Informer annotation on {}", (Object)declaringType);
            }
            List<String> namespaces = new ArrayList<String>();
            String[] namespacesArr = typeAnnotation.namespaces();
            Collections.addAll(namespaces, namespacesArr);
            if (!Objects.equals(typeAnnotation.namespacesSupplier(), EmptyNamespacesSupplier.class)) {
                Class<? extends Supplier<String[]>> namespaceSupplierClass = typeAnnotation.namespacesSupplier();
                Supplier supplierBean = (Supplier)this.applicationContext.getBean(namespaceSupplierClass);
                Collections.addAll(namespaces, (Object[])supplierBean.get());
            }
            if (!(namespace = typeAnnotation.namespace()).equals("RESOLVE_AUTOMATICALLY")) {
                namespaces.add(namespace);
            }
            if (namespace.equals("RESOLVE_AUTOMATICALLY") && namespaces.isEmpty()) {
                namespaces.add(this.namespaceResolver.resolveNamespace());
            }
            if (namespaces.contains("ALL_NAMESPACES")) {
                namespaces = Collections.singletonList("");
            }
            String labelSelector = null;
            if (!Objects.equals(typeAnnotation.labelSelector(), "")) {
                labelSelector = typeAnnotation.labelSelector();
            }
            if (!Objects.equals(typeAnnotation.labelSelectorSupplier(), EmptyLabelSupplier.class)) {
                Class<? extends Supplier<String>> selectorSupplierClass = typeAnnotation.labelSelectorSupplier();
                Supplier supplierBean = (Supplier)this.applicationContext.getBean(selectorSupplierClass);
                labelSelector = labelSelector == null ? (String)supplierBean.get() : labelSelector + "," + (String)supplierBean.get();
            }
            String resourcePlural = typeAnnotation.resourcePlural();
            String apiGroup = typeAnnotation.apiGroup();
            if (resourcePlural.equals("RESOLVE_AUTOMATICALLY") || apiGroup.equals("RESOLVE_AUTOMATICALLY")) {
                if (this.discoveryCache == null) {
                    throw new IllegalArgumentException("The discovery cache is disabled, provide `resourcePlural` and `apiGroup` parameters to create shared informer.");
                }
                Optional apiResourceOptional = this.discoveryCache.find(typeAnnotation.apiType());
                if (apiResourceOptional.isPresent()) {
                    Discovery.APIResource apiResource = (Discovery.APIResource)apiResourceOptional.get();
                    if (apiGroup.equals("RESOLVE_AUTOMATICALLY")) {
                        apiGroup = apiResource.getGroup();
                    }
                    if (resourcePlural.equals("RESOLVE_AUTOMATICALLY")) {
                        resourcePlural = apiResource.getResourcePlural();
                    }
                    if (apiResource.getNamespaced() != null && !apiResource.getNamespaced().booleanValue()) {
                        namespaces = Collections.singletonList("");
                    }
                } else {
                    throw new IllegalArgumentException("Failed to resolve `resourcePlural` and/or `apiGroup` for " + typeAnnotation.apiType() + " from discovery cache.");
                }
            }
            List<SharedIndexInformer<KubernetesObject>> informers = this.sharedIndexInformerFactory.sharedIndexInformersFor(typeAnnotation.apiType(), typeAnnotation.apiListType(), resourcePlural, apiGroup, namespaces, labelSelector, typeAnnotation.resyncCheckPeriod(), true);
            ResourceEventHandler resourceEventHandler = (ResourceEventHandler)context.proceed();
            informers.forEach(i -> i.addEventHandler(resourceEventHandler));
            return resourceEventHandler;
        }
        if (LOG.isErrorEnabled()) {
            LOG.error("Failed to create informer for the class [{}] that implements ResourceEventHandler. The io.micronaut.kubernetes.informer.@Informer annotation is missing.", (Object)declaringType.getName());
        }
        return (ResourceEventHandler)context.proceed();
    }
}

