/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.operator;

import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.kubernetes.client.operator.ControllerConfiguration;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

@Internal
public class ControllerConfigurationImpl
implements ControllerConfiguration {
    private String name;
    private Class<? extends KubernetesObject> apiType;
    private Class<? extends KubernetesListObject> apiListType;
    private String resourcePlural;
    private String apiGroup;
    private Set<String> namespaces;
    private String labelSelector;
    private Long resyncCheckPeriod;
    private Predicate<? extends KubernetesObject> onAddFilter;
    private BiPredicate<? extends KubernetesObject, ? extends KubernetesObject> onUpdateFilter;
    private BiPredicate<? extends KubernetesObject, Boolean> onDeleteFilter;

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @NonNull
    public Class<? extends KubernetesObject> getApiType() {
        return this.apiType;
    }

    @Override
    @NonNull
    public Class<? extends KubernetesListObject> getApiListType() {
        return this.apiListType;
    }

    @Override
    @NonNull
    public String getResourcePlural() {
        return this.resourcePlural;
    }

    @Override
    @NonNull
    public String getApiGroup() {
        return this.apiGroup;
    }

    @Override
    @NonNull
    public Set<String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    @NonNull
    public String getLabelSelector() {
        if (this.labelSelector == null) {
            return "";
        }
        return this.labelSelector;
    }

    @Override
    @NonNull
    public Long getResyncCheckPeriod() {
        if (this.resyncCheckPeriod == null) {
            return 0L;
        }
        return this.resyncCheckPeriod;
    }

    @Override
    public Predicate<? extends KubernetesObject> getOnAddFilter() {
        return this.onAddFilter;
    }

    @Override
    public BiPredicate<? extends KubernetesObject, ? extends KubernetesObject> getOnUpdateFilter() {
        return this.onUpdateFilter;
    }

    @Override
    public BiPredicate<? extends KubernetesObject, Boolean> getOnDeleteFilter() {
        return this.onDeleteFilter;
    }

    public String toString() {
        return "ControllerConfiguration{name='" + this.name + '\'' + ", apiType=" + this.apiType + ", apiListType=" + this.apiListType + ", resourcePlural='" + this.resourcePlural + '\'' + ", apiGroup='" + this.apiGroup + '\'' + ", namespaces=" + this.namespaces + ", labelSelector='" + this.labelSelector + '\'' + ", resyncCheckPeriod=" + this.resyncCheckPeriod + ", onAddFilter=" + this.onAddFilter + ", onUpdateFilter=" + this.onUpdateFilter + ", onDeleteFilter=" + this.onDeleteFilter + '}';
    }

    public static class ControllerConfigurationBuilder {
        private final ControllerConfigurationImpl controllerConfiguration = new ControllerConfigurationImpl();

        public ControllerConfigurationBuilder withName(String name) {
            this.controllerConfiguration.name = name;
            return this;
        }

        public ControllerConfigurationBuilder withApiType(Class<? extends KubernetesObject> apiType) {
            this.controllerConfiguration.apiType = apiType;
            return this;
        }

        public ControllerConfigurationBuilder withApiListType(Class<? extends KubernetesListObject> apiListType) {
            this.controllerConfiguration.apiListType = apiListType;
            return this;
        }

        public ControllerConfigurationBuilder withResourcePlural(String resourcePlural) {
            this.controllerConfiguration.resourcePlural = resourcePlural;
            return this;
        }

        public ControllerConfigurationBuilder withApiGroup(String apiGroup) {
            this.controllerConfiguration.apiGroup = apiGroup;
            return this;
        }

        public ControllerConfigurationBuilder withNamespaces(Set<String> namespaces) {
            this.controllerConfiguration.namespaces = namespaces;
            return this;
        }

        public ControllerConfigurationBuilder withLabelSelector(String labelSelector) {
            this.controllerConfiguration.labelSelector = labelSelector;
            return this;
        }

        public ControllerConfigurationBuilder withOnAddFilter(Predicate<? extends KubernetesObject> onAddFilter) {
            this.controllerConfiguration.onAddFilter = onAddFilter;
            return this;
        }

        public ControllerConfigurationBuilder withOnUpdateFilter(BiPredicate<? extends KubernetesObject, ? extends KubernetesObject> onUpdateFilter) {
            this.controllerConfiguration.onUpdateFilter = onUpdateFilter;
            return this;
        }

        public ControllerConfigurationBuilder withOnDeleteFilter(BiPredicate<? extends KubernetesObject, Boolean> onDeleteFilter) {
            this.controllerConfiguration.onDeleteFilter = onDeleteFilter;
            return this;
        }

        public ControllerConfigurationBuilder withResyncCheckPeriod(Long resyncCheckPeriod) {
            this.controllerConfiguration.resyncCheckPeriod = resyncCheckPeriod;
            return this;
        }

        public ControllerConfiguration build() {
            return this.controllerConfiguration;
        }
    }
}

