/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.operator.controller;

import io.kubernetes.client.extended.controller.Controller;
import io.kubernetes.client.extended.controller.ControllerManager;
import io.kubernetes.client.extended.controller.LeaderElectingController;
import io.kubernetes.client.extended.leaderelection.LeaderElectionConfig;
import io.kubernetes.client.extended.leaderelection.LeaderElector;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.kubernetes.client.operator.ControllerConfiguration;
import io.micronaut.kubernetes.client.operator.ResourceReconciler;
import io.micronaut.kubernetes.client.operator.controller.DefaultControllerManagerBuilder;
import io.micronaut.kubernetes.client.operator.controller.LeaderElectingControllerBuilder;
import io.micronaut.kubernetes.client.operator.event.LeaseAcquiredEvent;
import io.micronaut.kubernetes.client.operator.event.LeaseLostEvent;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultLeaderElectingControllerBuilder
implements LeaderElectingControllerBuilder {
    public static final Logger LOG = LoggerFactory.getLogger(DefaultControllerManagerBuilder.class);
    private final LeaderElectionConfig leaderElectionConfig;
    private final ApplicationEventPublisher<LeaseLostEvent> leaseLostEventApplicationEventPublisher;
    private final ApplicationEventPublisher<LeaseAcquiredEvent> leaseAcquiredEventApplicationEventPublisher;

    public DefaultLeaderElectingControllerBuilder(LeaderElectionConfig leaderElectionConfig, ApplicationEventPublisher<LeaseLostEvent> leaseLostEventApplicationEventPublisher, ApplicationEventPublisher<LeaseAcquiredEvent> leaseAcquiredEventApplicationEventPublisher) {
        this.leaderElectionConfig = leaderElectionConfig;
        this.leaseLostEventApplicationEventPublisher = leaseLostEventApplicationEventPublisher;
        this.leaseAcquiredEventApplicationEventPublisher = leaseAcquiredEventApplicationEventPublisher;
    }

    @Override
    @NonNull
    public LeaderElectingController build(@NonNull ControllerConfiguration operator, @NonNull ResourceReconciler<?> resourceReconciler, @NonNull ControllerManager controllerManager) {
        LeaderElector leaderElector = new LeaderElector(this.leaderElectionConfig);
        ApplicationContextEventEmitterController eventEmitterController = new ApplicationContextEventEmitterController(this.leaseLostEventApplicationEventPublisher, this.leaseAcquiredEventApplicationEventPublisher, controllerManager, operator);
        LeaderElectingController leaderElectingController = new LeaderElectingController(leaderElector, (Controller)eventEmitterController);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created leader electing controller for operator: " + operator.getName());
        }
        return leaderElectingController;
    }

    static class ApplicationContextEventEmitterController
    implements Controller {
        private final ApplicationEventPublisher<LeaseLostEvent> leaseLostEventApplicationEventPublisher;
        private final ApplicationEventPublisher<LeaseAcquiredEvent> leaseAcquiredEventApplicationEventPublisher;
        private final ControllerManager delegateController;
        private final ControllerConfiguration controllerConfiguration;

        public ApplicationContextEventEmitterController(ApplicationEventPublisher<LeaseLostEvent> leaseLostEventApplicationEventPublisher, ApplicationEventPublisher<LeaseAcquiredEvent> leaseAcquiredEventApplicationEventPublisher, ControllerManager delegateController, ControllerConfiguration controllerConfiguration) {
            this.leaseAcquiredEventApplicationEventPublisher = leaseAcquiredEventApplicationEventPublisher;
            this.leaseLostEventApplicationEventPublisher = leaseLostEventApplicationEventPublisher;
            this.delegateController = delegateController;
            this.controllerConfiguration = controllerConfiguration;
        }

        public void shutdown() {
            this.leaseLostEventApplicationEventPublisher.publishEvent((Object)new LeaseLostEvent(this.controllerConfiguration, this.delegateController));
            this.delegateController.shutdown();
        }

        public void run() {
            this.leaseAcquiredEventApplicationEventPublisher.publishEvent((Object)new LeaseAcquiredEvent(this.controllerConfiguration, this.delegateController));
            this.delegateController.run();
        }
    }
}

