/*
 * Copyright 2017-2021 original authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.micronaut.kubernetes.client.operator.controller;

import io.kubernetes.client.extended.controller.Controller;
import io.kubernetes.client.extended.controller.ControllerManager;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.kubernetes.client.operator.ControllerConfiguration;
import jakarta.inject.Singleton;
import org.jetbrains.annotations.NotNull;

import java.util.Collection;

/**
 * The default implementation of {@link ControllerManagerBuilder}.
 *
 * @author Pavol Gressa
 * @since 3.3
 */
@Singleton
@Internal
public class DefaultControllerManagerBuilder implements ControllerManagerBuilder {

    private final SharedInformerFactory informerFactory;

    public DefaultControllerManagerBuilder(SharedInformerFactory informerFactory) {
        this.informerFactory = informerFactory;
    }

    @NotNull
    @Override
    public ControllerManager build(@NonNull ControllerConfiguration operator, @NonNull Collection<Controller> controllers) {
        return new ControllerManager(informerFactory, controllers.toArray(new Controller[0]));
    }
}
