/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.operator;

import io.kubernetes.client.common.KubernetesObject;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.kubernetes.client.informer.Informer;
import io.micronaut.kubernetes.client.informer.InformerAnnotationUtils;
import io.micronaut.kubernetes.client.informer.resolvers.InformerApiGroupResolver;
import io.micronaut.kubernetes.client.informer.resolvers.InformerLabelSelectorResolver;
import io.micronaut.kubernetes.client.informer.resolvers.InformerNamespaceResolver;
import io.micronaut.kubernetes.client.informer.resolvers.InformerResourcePluralResolver;
import io.micronaut.kubernetes.client.operator.ControllerConfiguration;
import io.micronaut.kubernetes.client.operator.ControllerConfigurationImpl;
import io.micronaut.kubernetes.client.operator.Operator;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.naming.ConfigurationException;

@Factory
public class ControllerConfigurationFactory {
    private final BeanContext beanContext;
    private final InformerApiGroupResolver apiGroupResolver;
    private final InformerResourcePluralResolver resourcePluralResolver;
    private final InformerNamespaceResolver namespaceResolver;
    private final InformerLabelSelectorResolver labelSelectorResolver;

    public ControllerConfigurationFactory(@NonNull BeanContext beanContext, @NonNull InformerApiGroupResolver apiGroupResolver, @NonNull InformerResourcePluralResolver resourcePluralResolver, @NonNull InformerNamespaceResolver namespaceResolver, @NonNull InformerLabelSelectorResolver labelSelectorResolver) {
        this.beanContext = beanContext;
        this.apiGroupResolver = apiGroupResolver;
        this.resourcePluralResolver = resourcePluralResolver;
        this.namespaceResolver = namespaceResolver;
        this.labelSelectorResolver = labelSelectorResolver;
    }

    @Prototype
    public ControllerConfiguration operatorConfiguration(@Parameter AnnotationValue<Operator> annotationValue) throws ConfigurationException {
        Optional optionalInformer = annotationValue.getAnnotation("informer", Informer.class);
        if (!optionalInformer.isPresent()) {
            throw new ConfigurationException("Failed to configure the Operator Controller. The @Informer is required.");
        }
        AnnotationValue informer = (AnnotationValue)optionalInformer.get();
        Class apiType = InformerAnnotationUtils.resolveApiType((AnnotationValue)informer);
        String name = annotationValue.get((CharSequence)"name", String.class).orElseGet(() -> "Operator" + apiType.getSimpleName());
        ControllerConfigurationImpl.ControllerConfigurationBuilder builder = new ControllerConfigurationImpl.ControllerConfigurationBuilder();
        return builder.withApiType(apiType).withApiListType(InformerAnnotationUtils.resolveApiListType((AnnotationValue)informer)).withApiGroup(this.apiGroupResolver.resolveInformerApiGroup(informer)).withResourcePlural(this.resourcePluralResolver.resolveInformerResourcePlural(informer)).withNamespaces(this.namespaceResolver.resolveInformerNamespaces(informer)).withLabelSelector(this.labelSelectorResolver.resolveInformerLabels(informer)).withOnAddFilter(this.getOnAddFilter(annotationValue)).withOnUpdateFilter(this.getOnUpdateFilter(annotationValue)).withOnDeleteFilter(this.getOnDeleteFilter(annotationValue)).withName(name).withResyncCheckPeriod(informer.get((CharSequence)"resyncCheckPeriod", Long.class).orElse(0L)).build();
    }

    protected Predicate<? extends KubernetesObject> getOnAddFilter(AnnotationValue<Operator> operator) {
        Optional onAddFilter = operator.classValue("onAddFilter", Predicate.class);
        return onAddFilter.map(arg_0 -> ((BeanContext)this.beanContext).getBean(arg_0)).orElse(null);
    }

    protected BiPredicate<? extends KubernetesObject, ? extends KubernetesObject> getOnUpdateFilter(AnnotationValue<Operator> operator) {
        Optional onUpdateFilter = operator.classValue("onUpdateFilter", BiPredicate.class);
        return onUpdateFilter.map(arg_0 -> ((BeanContext)this.beanContext).getBean(arg_0)).orElse(null);
    }

    protected BiPredicate<? extends KubernetesObject, Boolean> getOnDeleteFilter(AnnotationValue<Operator> operator) {
        Optional onDeleteFilter = operator.classValue("onDeleteFilter", BiPredicate.class);
        return onDeleteFilter.map(arg_0 -> ((BeanContext)this.beanContext).getBean(arg_0)).orElse(null);
    }
}

