/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.operator;

import io.kubernetes.client.extended.controller.Controller;
import io.kubernetes.client.extended.controller.ControllerManager;
import io.kubernetes.client.extended.controller.DefaultController;
import io.kubernetes.client.extended.controller.LeaderElectingController;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.kubernetes.client.operator.ControllerConfiguration;
import io.micronaut.kubernetes.client.operator.ResourceReconciler;
import io.micronaut.kubernetes.client.operator.controller.ControllerBuilder;
import io.micronaut.kubernetes.client.operator.controller.ControllerManagerBuilder;
import io.micronaut.kubernetes.client.operator.controller.LeaderElectingControllerBuilder;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.concurrent.ExecutorService;
import org.apache.commons.compress.utils.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(beans={SharedInformerFactory.class})
@Singleton
@Internal
public class ControllerFactory {
    public static final Logger LOG = LoggerFactory.getLogger(ControllerFactory.class);
    private final BeanContext beanContext;
    private final ControllerBuilder controllerBuilder;
    private final ControllerManagerBuilder controllerManagerBuilder;
    private final LeaderElectingControllerBuilder leaderElectingControllerBuilder;
    private final ExecutorService executorService;

    public ControllerFactory(@NonNull BeanContext beanContext, @NonNull ControllerBuilder controllerBuilder, @NonNull ControllerManagerBuilder controllerManagerBuilder, @NonNull LeaderElectingControllerBuilder leaderElectingControllerBuilder, @Named(value="io") ExecutorService executorService) {
        this.beanContext = beanContext;
        this.controllerBuilder = controllerBuilder;
        this.controllerManagerBuilder = controllerManagerBuilder;
        this.leaderElectingControllerBuilder = leaderElectingControllerBuilder;
        this.executorService = executorService;
    }

    @NonNull
    public void createControllers(@NonNull ResourceReconciler<?> reconciler, @NonNull ControllerConfiguration controllerConfiguration) {
        String controllerName = controllerConfiguration.getName();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating controllers for " + controllerName + " operator ");
        }
        DefaultController controller = this.controllerBuilder.build(controllerConfiguration, reconciler);
        this.beanContext.registerSingleton(DefaultController.class, (Object)controller, Qualifiers.byName((String)controllerName));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Injected DefaultController with @Named qualifier: " + controllerName + " to the bean context");
        }
        ControllerManager controllerManager = this.controllerManagerBuilder.build(controllerConfiguration, Sets.newHashSet((Object[])new Controller[]{controller}));
        this.beanContext.registerSingleton(ControllerManager.class, (Object)controllerManager, Qualifiers.byName((String)controllerName));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Injected ControllerManager with @Named qualifier: " + controllerName + " to the bean context");
        }
        LeaderElectingController leaderElectingController = this.leaderElectingControllerBuilder.build(controllerConfiguration, reconciler, controllerManager);
        this.beanContext.registerSingleton(LeaderElectingController.class, (Object)leaderElectingController, Qualifiers.byName((String)controllerName));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Injected leaderElectingController with @Named qualifier: " + controllerName + " to the bean context");
        }
        this.executorService.execute((Runnable)leaderElectingController);
        if (LOG.isInfoEnabled()) {
            LOG.info("@Operator name: " + controllerName + " for type: " + controllerConfiguration.getApiType() + " started");
        }
    }
}

