/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.operator;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.extended.controller.reconciler.Request;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.util.Strings;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.kubernetes.client.informer.SharedIndexInformerFactory;
import io.micronaut.kubernetes.client.operator.ControllerConfiguration;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.map.HashedMap;

public class OperatorResourceLister<ApiType extends KubernetesObject> {
    private final SharedIndexInformerFactory sharedIndexInformerFactory;
    private final ControllerConfiguration controllerConfiguration;
    private final Map<String, SharedIndexInformer<ApiType>> informerMap;

    public OperatorResourceLister(@NonNull ControllerConfiguration controllerConfiguration, @NonNull SharedIndexInformerFactory sharedIndexInformerFactory) {
        this.sharedIndexInformerFactory = sharedIndexInformerFactory;
        this.controllerConfiguration = controllerConfiguration;
        this.informerMap = new HashedMap(controllerConfiguration.getNamespaces().size());
    }

    @NonNull
    public Optional<ApiType> get(@NonNull Request request) {
        SharedIndexInformer sharedIndexInformer = this.informerMap.computeIfAbsent(request.getNamespace(), namespace -> {
            Class<? extends KubernetesObject> apiType = this.controllerConfiguration.getApiType();
            return this.sharedIndexInformerFactory.getExistingSharedIndexInformer(namespace, apiType);
        });
        String key = OperatorResourceLister.metaNamespaceKeyFunc(request.getNamespace(), request.getName());
        return Optional.ofNullable((KubernetesObject)sharedIndexInformer.getIndexer().getByKey(key));
    }

    static String metaNamespaceKeyFunc(String namespace, String name) {
        if (!Strings.isNullOrEmpty((String)namespace)) {
            return namespace + "/" + name;
        }
        return name;
    }
}

