/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.operator;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.kubernetes.client.operator.ControllerConfiguration;
import io.micronaut.kubernetes.client.operator.ControllerFactory;
import io.micronaut.kubernetes.client.operator.Operator;
import io.micronaut.kubernetes.client.operator.ResourceReconciler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(beans={SharedInformerFactory.class})
@Context
@Internal
public class ResourceReconcilerCreatedListener<ApiType extends KubernetesObject>
implements BeanCreatedEventListener<ResourceReconciler<ApiType>> {
    public static final Logger LOG = LoggerFactory.getLogger(ResourceReconcilerCreatedListener.class);
    private final BeanContext beanContext;
    private final ControllerFactory controllerFactory;

    public ResourceReconcilerCreatedListener(BeanContext beanContext, @NonNull ControllerFactory controllerFactory) {
        this.beanContext = beanContext;
        this.controllerFactory = controllerFactory;
    }

    public ResourceReconciler<ApiType> onCreated(BeanCreatedEvent<ResourceReconciler<ApiType>> event) {
        ResourceReconciler resourceReconciler = (ResourceReconciler)event.getBean();
        BeanDefinition beanDefinition = event.getBeanDefinition();
        if (beanDefinition.hasAnnotation(Operator.class)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found @Operator annotation on {}", (Object)resourceReconciler);
            }
            AnnotationValue annotationValue = beanDefinition.getAnnotationMetadata().getAnnotation(Operator.class);
            ControllerConfiguration controllerConfiguration = (ControllerConfiguration)this.beanContext.createBean(ControllerConfiguration.class, new Object[]{annotationValue});
            if (LOG.isDebugEnabled()) {
                LOG.debug("Final controller configuration: {}", (Object)controllerConfiguration);
            }
            this.controllerFactory.createControllers(resourceReconciler, controllerConfiguration);
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("Bean [{}] implements ResourceReconciler but the io.micronaut.kubernetes.client.operator.@Operator annotation is missing.", (Object)resourceReconciler);
        }
        return resourceReconciler;
    }
}

