/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.operator.configuration;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.kubernetes.client.operator.configuration.LeaderElectionConfiguration;
import java.time.Duration;
import java.util.Optional;

@ConfigurationProperties(value="kubernetes.client.operator.leader-election.lock")
public class LeaderElectionConfigurationProperties
implements LeaderElectionConfiguration {
    public static final String PREFIX = "kubernetes.client.operator.leader-election.lock";
    public static final Integer DEFAULT_LEASE_DURATION_IN_SECONDS = 10;
    public static final Integer DEFAULT_RENEW_DEADLINE_IN_SECONDS = 8;
    public static final Integer DEFAULT_RETRY_PERIOD_IN_SECONDS = 5;
    private Duration leaseDuration = Duration.ofSeconds(DEFAULT_LEASE_DURATION_IN_SECONDS.intValue());
    private Duration renewDeadline = Duration.ofSeconds(DEFAULT_RENEW_DEADLINE_IN_SECONDS.intValue());
    private Duration retryPeriod = Duration.ofSeconds(DEFAULT_RETRY_PERIOD_IN_SECONDS.intValue());
    private String resourceName;
    private String resourceNamespace;

    @Override
    @NonNull
    public Duration getLeaseDuration() {
        return this.leaseDuration;
    }

    public void setLeaseDuration(@NonNull Duration leaseDuration) {
        this.leaseDuration = leaseDuration;
    }

    @Override
    @NonNull
    public Duration getRenewDeadline() {
        return this.renewDeadline;
    }

    public void setRenewDeadline(@NonNull Duration renewDeadline) {
        this.renewDeadline = renewDeadline;
    }

    @Override
    @NonNull
    public Duration getRetryPeriod() {
        return this.retryPeriod;
    }

    public void setRetryPeriod(@NonNull Duration retryPeriod) {
        this.retryPeriod = retryPeriod;
    }

    @Override
    @NonNull
    public Optional<String> getResourceName() {
        return Optional.ofNullable(this.resourceName);
    }

    public void setResourceName(@NonNull String resourceName) {
        this.resourceName = resourceName;
    }

    @Override
    @NonNull
    public Optional<String> getResourceNamespace() {
        return Optional.ofNullable(this.resourceNamespace);
    }

    public void setResourceNamespace(@NonNull String resourceNamespace) {
        this.resourceNamespace = resourceNamespace;
    }
}

