/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.operator.controller;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.extended.controller.ControllerWatch;
import io.kubernetes.client.extended.controller.Controllers;
import io.kubernetes.client.extended.controller.DefaultController;
import io.kubernetes.client.extended.controller.reconciler.Request;
import io.kubernetes.client.extended.workqueue.RateLimitingQueue;
import io.kubernetes.client.extended.workqueue.WorkQueue;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.kubernetes.client.informer.SharedIndexInformerFactory;
import io.micronaut.kubernetes.client.operator.ControllerConfiguration;
import io.micronaut.kubernetes.client.operator.OperatorResourceLister;
import io.micronaut.kubernetes.client.operator.ResourceReconciler;
import io.micronaut.kubernetes.client.operator.configuration.OperatorConfigurationProperties;
import io.micronaut.kubernetes.client.operator.controller.ControllerBuilder;
import io.micronaut.kubernetes.client.operator.controller.ControllerWatchBuilder;
import jakarta.inject.Singleton;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Internal
public class DefaultControllerBuilder
implements ControllerBuilder {
    public static final Logger LOG = LoggerFactory.getLogger(DefaultControllerBuilder.class);
    private final BeanContext beanContext;
    private final ControllerWatchBuilder controllerWatchBuilder;
    private final SharedIndexInformerFactory sharedIndexInformerFactory;
    private final OperatorConfigurationProperties operatorConfiguration;

    public DefaultControllerBuilder(@NonNull BeanContext beanContext, @NonNull ControllerWatchBuilder controllerWatchBuilder, @NonNull SharedIndexInformerFactory sharedIndexInformerFactory, @NonNull OperatorConfigurationProperties operatorConfiguration) {
        this.beanContext = beanContext;
        this.controllerWatchBuilder = controllerWatchBuilder;
        this.sharedIndexInformerFactory = sharedIndexInformerFactory;
        this.operatorConfiguration = operatorConfiguration;
    }

    @Override
    @NonNull
    public DefaultController build(@NonNull ControllerConfiguration controllerConfiguration, @NonNull ResourceReconciler<?> resourceReconciler) {
        Set<String> namespaces = controllerConfiguration.getNamespaces();
        String name = controllerConfiguration.getName();
        RateLimitingQueue workQueue = (RateLimitingQueue)this.beanContext.createBean(RateLimitingQueue.class);
        this.beanContext.registerSingleton(RateLimitingQueue.class, (Object)workQueue, Qualifiers.byName((String)name));
        ControllerWatch<? extends KubernetesObject> controllerWatch = this.controllerWatchBuilder.buildControllerWatch(controllerConfiguration, (WorkQueue<Request>)workQueue);
        HashSet readyFuncs = new HashSet(namespaces.size());
        if (LOG.isInfoEnabled()) {
            LOG.info("Creating controller for " + controllerConfiguration.getName());
        }
        namespaces.forEach(namespace -> {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Creating controller[" + name + "] informer in namespace " + namespace);
            }
            SharedIndexInformer informer = this.sharedIndexInformerFactory.sharedIndexInformerFor(controllerConfiguration.getApiType(), controllerConfiguration.getApiListType(), controllerConfiguration.getResourcePlural(), controllerConfiguration.getApiGroup(), namespace, controllerConfiguration.getLabelSelector(), controllerConfiguration.getResyncCheckPeriod(), false);
            informer.addEventHandler(controllerWatch.getResourceEventHandler());
            readyFuncs.add(() -> ((SharedIndexInformer)informer).hasSynced());
        });
        DefaultController controller = new DefaultController(controllerConfiguration.getName(), request -> resourceReconciler.reconcile(request, new OperatorResourceLister(controllerConfiguration, this.sharedIndexInformerFactory)), workQueue, readyFuncs.toArray(new Supplier[0]));
        this.operatorConfiguration.getReadyTimeout().ifPresent(arg_0 -> ((DefaultController)controller).setReadyTimeout(arg_0));
        int workerCount = this.operatorConfiguration.getWorkerCount();
        controller.setWorkerCount(workerCount);
        controller.setWorkerThreadPool(Executors.newScheduledThreadPool(workerCount, Controllers.namedControllerThreadFactory((String)(name + "-controller"))));
        return controller;
    }
}

