/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.operator.controller;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.extended.controller.ControllerWatch;
import io.kubernetes.client.extended.controller.builder.ControllerBuilder;
import io.kubernetes.client.extended.controller.reconciler.Request;
import io.kubernetes.client.extended.workqueue.WorkQueue;
import io.micronaut.kubernetes.client.informer.InformerConfiguration;
import io.micronaut.kubernetes.client.operator.ControllerConfiguration;
import io.micronaut.kubernetes.client.operator.controller.ControllerWatchBuilder;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

@Singleton
public class DefaultControllerWatchBuilder
implements ControllerWatchBuilder {
    private final InformerConfiguration informerConfiguration;

    public DefaultControllerWatchBuilder(InformerConfiguration informerConfiguration) {
        this.informerConfiguration = informerConfiguration;
    }

    @Override
    @NotNull
    public ControllerWatch<? extends KubernetesObject> buildControllerWatch(@NotNull ControllerConfiguration operator, @NotNull WorkQueue<Request> workQueue) {
        Predicate<? extends KubernetesObject> onAddFilter = operator.getOnAddFilter();
        BiPredicate<? extends KubernetesObject, ? extends KubernetesObject> onUpdateFilter = operator.getOnUpdateFilter();
        BiPredicate<? extends KubernetesObject, Boolean> onDeleteFilter = operator.getOnDeleteFilter();
        long resyncCheckPeriod = operator.getResyncCheckPeriod();
        if (resyncCheckPeriod == 0L && this.informerConfiguration.getResyncPeriod().isPresent()) {
            resyncCheckPeriod = ((Duration)this.informerConfiguration.getResyncPeriod().get()).toMillis();
        }
        return ControllerBuilder.controllerWatchBuilder(operator.getApiType(), workQueue).withWorkQueueKeyFunc(node -> new Request(node.getMetadata().getNamespace(), node.getMetadata().getName())).withOnAddFilter(onAddFilter).withOnUpdateFilter(onUpdateFilter).withOnDeleteFilter(onDeleteFilter).withResyncPeriod(Duration.ofMillis(resyncCheckPeriod)).build();
    }
}

