/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.kubernetes.client.operator.leaderelection;

import io.kubernetes.client.extended.leaderelection.resourcelock.ConfigMapLock;
import io.kubernetes.client.extended.leaderelection.resourcelock.EndpointsLock;
import io.kubernetes.client.extended.leaderelection.resourcelock.LeaseLock;
import io.kubernetes.client.openapi.ApiClient;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.kubernetes.client.NamespaceResolver;
import io.micronaut.kubernetes.client.operator.configuration.LeaderElectionConfiguration;
import io.micronaut.kubernetes.client.operator.leaderelection.LockIdentityProvider;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Singleton;

@Factory
public class ResourceLockFactory {
    private final ApiClient apiClient;
    private final String lockName;
    private final String lockNamespace;
    private final String appIdentity;

    public ResourceLockFactory(LockIdentityProvider lockIdentityProvider, NamespaceResolver namespaceResolver, ApplicationConfiguration applicationConfiguration, LeaderElectionConfiguration leaderElectionConfiguration, ApiClient apiClient) {
        this.lockName = leaderElectionConfiguration.getResourceName().orElseGet(() -> (String)applicationConfiguration.getName().orElseThrow(() -> new IllegalArgumentException("Failed to resolve leader elector resource name. Configure the application name `micronaut.application.name` or provide the lock name explicitly `kubernetes.client.operator.leader-election.lock`.")));
        this.lockNamespace = leaderElectionConfiguration.getResourceNamespace().orElseGet(() -> ((NamespaceResolver)namespaceResolver).resolveNamespace());
        this.appIdentity = lockIdentityProvider.getIdentity();
        this.apiClient = apiClient;
    }

    @Requires(property="kubernetes.client.operator.leader-election.lock.resource-kind", value="configmap")
    @Primary
    @Singleton
    public ConfigMapLock configMapLock() {
        return new ConfigMapLock(this.lockNamespace, this.lockName, this.appIdentity, this.apiClient);
    }

    @Requires(property="kubernetes.client.operator.leader-election.lock.resource-kind", value="endpoints")
    @Primary
    @Singleton
    public EndpointsLock endpointsLock() {
        return new EndpointsLock(this.lockNamespace, this.lockName, this.appIdentity, this.apiClient);
    }

    @Requires(property="kubernetes.client.operator.leader-election.lock.resource-kind", value="lease", defaultValue="lease")
    @Secondary
    @Singleton
    public LeaseLock leaseLock() {
        return new LeaseLock(this.lockNamespace, this.lockName, this.appIdentity, this.apiClient);
    }
}

