/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.langchain4j.processor;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationInject;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.langchain4j.annotation.Lang4jConfig;
import io.micronaut.sourcegen.generator.SourceGenerator;
import io.micronaut.sourcegen.generator.SourceGenerators;
import io.micronaut.sourcegen.model.AnnotationDef;
import io.micronaut.sourcegen.model.ClassDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.ExpressionDef;
import io.micronaut.sourcegen.model.FieldDef;
import io.micronaut.sourcegen.model.MethodDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.ParameterDef;
import io.micronaut.sourcegen.model.PropertyDef;
import io.micronaut.sourcegen.model.RecordDef;
import io.micronaut.sourcegen.model.StatementDef;
import io.micronaut.sourcegen.model.TypeDef;
import io.micronaut.sourcegen.model.VariableDef;
import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;

@Internal
public class Langchain4jConfigVisitor
implements TypeElementVisitor<Lang4jConfig, Object> {
    public static final String CONFIG_PREFIX = "langchain4j.";
    private static final Map<String, String> MODEL_NAME_MAPPINGS = Map.of("ChatLanguageModel", "ChatModel", "StreamingChatLanguageModel", "StreamingChatModel");
    private static final String CTOR_NAME = "<init>";

    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    public Set<String> getSupportedAnnotationNames() {
        return Set.of(Lang4jConfig.class.getName());
    }

    public void visitClass(ClassElement element, VisitorContext context) {
        SourceGenerator generator = SourceGenerators.findByLanguage((VisitorContext.Language)context.getLanguage()).orElse(null);
        AnnotationValue lang4jConfig = element.findAnnotation(Lang4jConfig.class).orElse(null);
        String packageName = element.getPackageName();
        if (generator != null && lang4jConfig != null) {
            List<PropertyConfig> properties = lang4jConfig.getAnnotations("properties", Lang4jConfig.Property.class).stream().map(PropertyConfig::new).toList();
            List<PropertyConfig> commonProperties = properties.stream().filter(p -> p.common && !p.injected).toList();
            List providers = lang4jConfig.getAnnotations("models", Lang4jConfig.Model.class);
            RecordDef commonConfig = Langchain4jConfigVisitor.buildCommonConfig(element, context, commonProperties, providers, packageName, generator);
            for (AnnotationValue provider : providers) {
                ModelConfig modelConfig = Langchain4jConfigVisitor.getModelConfig(element, context, (AnnotationValue<Lang4jConfig.Model>)provider);
                MethodElement modelNameMethod = modelConfig.builderType.getEnclosedElement(ElementQuery.ALL_METHODS.named("modelName").onlyAccessible().onlyInstance()).orElse(null);
                String[] requiredInjects = (String[])properties.stream().filter(p -> p.required && p.injected).map(p -> p.name).toArray(String[]::new);
                String[] optionalInjects = (String[])properties.stream().filter(p -> !p.required && p.injected).map(p -> p.name).toArray(String[]::new);
                if (!StringUtils.isNotEmpty((CharSequence)packageName)) continue;
                String namedPrefix = modelConfig.getNamedPrefix();
                String namedConfigSimpleName = "Named" + modelConfig.languageModel().getSimpleName() + "Configuration";
                String namedConfigQualifiedName = packageName + "." + namedConfigSimpleName;
                ClassDef namedConfigDef = Langchain4jConfigVisitor.buildNamedConfigurationDef(namedPrefix, namedConfigQualifiedName, modelConfig.languageModel(), modelConfig.builderType, requiredInjects, optionalInjects, commonConfig, modelNameMethod, modelConfig.defaultModelName);
                Langchain4jConfigVisitor.writeJavaSource(generator, context, element, packageName, namedConfigSimpleName, (ObjectDef)namedConfigDef, modelConfig.modelKind);
                String defaultPrefix = modelConfig.getDefaultPrefix();
                String defaultConfigSimpleName = "Default" + modelConfig.languageModel().getSimpleName() + "Configuration";
                String defaultConfigQualifiedName = packageName + "." + defaultConfigSimpleName;
                ClassDef defaultConfigDef = Langchain4jConfigVisitor.buildDefaultConfigurationDef(defaultPrefix, defaultConfigQualifiedName, modelConfig.languageModel(), modelConfig.builderType, requiredInjects, optionalInjects, commonConfig, modelNameMethod, modelConfig.defaultModelName, modelConfig.configRequired);
                Langchain4jConfigVisitor.writeJavaSource(generator, context, element, packageName, defaultConfigSimpleName, (ObjectDef)defaultConfigDef, modelConfig.modelKind);
                String factorySimpleName = modelConfig.languageModel().getSimpleName() + "Factory";
                String factoryName = packageName + "." + factorySimpleName;
                if (!context.getClassElement(factoryName).isEmpty()) continue;
                ClassDef factoryDef = this.buildFactory(namedConfigDef, defaultConfigDef, modelConfig.builderType, factoryName, modelConfig.languageModel(), modelConfig.languageModelKind(), modelConfig.exposed());
                Langchain4jConfigVisitor.writeJavaSource(generator, context, element, packageName, factorySimpleName, (ObjectDef)factoryDef, modelConfig.modelKind);
            }
        }
    }

    private static RecordDef buildCommonConfig(ClassElement element, VisitorContext context, List<PropertyConfig> commonProperties, List<AnnotationValue<Lang4jConfig.Model>> providers, String packageName, SourceGenerator generator) {
        RecordDef commonConfig = null;
        if (!commonProperties.isEmpty() && !providers.isEmpty()) {
            ModelConfig firstConfig = Langchain4jConfigVisitor.getModelConfig(element, context, providers.iterator().next());
            String commonConfigSimpleName = "Common" + firstConfig.languageModel().getSimpleName() + "Configuration";
            String prefix = firstConfig.getCommonPrefix();
            RecordDef.RecordDefBuilder recordDefBuilder = (RecordDef.RecordDefBuilder)((RecordDef.RecordDefBuilder)((RecordDef.RecordDefBuilder)((RecordDef.RecordDefBuilder)((RecordDef.RecordDefBuilder)RecordDef.builder((String)(packageName + "." + commonConfigSimpleName)).addModifiers(new Modifier[]{Modifier.PUBLIC})).addAnnotation(Context.class)).addAnnotation(AnnotationDef.builder(Requires.class).addMember("property", (Object)prefix).build())).addAnnotation(AnnotationDef.builder(Requires.class).addMember("property", (Object)(prefix + ".enabled")).addMember("value", (Object)"true").addMember("defaultValue", (Object)"true").build())).addAnnotation(AnnotationDef.builder(ConfigurationProperties.class).addMember("value", (Object)prefix).build());
            ClassElement builderType = firstConfig.builderType();
            recordDefBuilder.addProperty(((PropertyDef.PropertyDefBuilder)PropertyDef.builder((String)"enabled").ofType(Boolean.TYPE).addAnnotation(AnnotationDef.builder(Bindable.class).addMember("defaultValue", (Object)"true").build())).build());
            for (PropertyConfig property : commonProperties) {
                builderType.getEnclosedElement(ElementQuery.ALL_METHODS.onlyInstance().onlyAccessible().named(n -> n.equals(property.name)).filter(m -> !m.getGenericReturnType().isVoid() && m.hasParameters())).ifPresent(methodElement -> {
                    PropertyDef.PropertyDefBuilder builder = PropertyDef.builder((String)property.name);
                    if (property.defaultValue != null) {
                        builder.addAnnotation(AnnotationDef.builder(Bindable.class).addMember("defaultValue", (Object)property.defaultValue).build());
                    }
                    ClassElement propertyType = methodElement.getParameters()[0].getGenericType();
                    if (!(property.required || propertyType.isPrimitive() && !propertyType.isArray())) {
                        builder.addAnnotation(Nullable.class);
                    }
                    recordDefBuilder.addProperty(builder.ofType(TypeDef.of((TypedElement)propertyType)).build());
                });
            }
            commonConfig = recordDefBuilder.build();
            Langchain4jConfigVisitor.writeJavaSource(generator, context, element, packageName, commonConfigSimpleName, (ObjectDef)commonConfig, firstConfig.modelKind);
        }
        return commonConfig;
    }

    private static ModelConfig getModelConfig(ClassElement element, VisitorContext context, AnnotationValue<Lang4jConfig.Model> provider) {
        ClassElement languageModel = provider.stringValue("impl").flatMap(arg_0 -> ((VisitorContext)context).getClassElement(arg_0)).orElse(null);
        ClassElement languageModelKind = provider.stringValue("kind").flatMap(arg_0 -> ((VisitorContext)context).getClassElement(arg_0)).orElse(null);
        ClassElement exposedKind = provider.stringValue("exposed").flatMap(arg_0 -> ((VisitorContext)context).getClassElement(arg_0)).orElse(null);
        String defaultModelName = provider.stringValue("defaultModelName").orElse(null);
        boolean configRequired = provider.booleanValue("configRequired").orElse(false);
        if (languageModelKind == null) {
            throw new ProcessingException((Element)element, "@ModelProvider kind must be on the compilation classpath");
        }
        if (languageModel == null) {
            throw new ProcessingException((Element)element, "@ModelProvider kind must be on the compilation classpath");
        }
        return new ModelConfig(languageModel, languageModelKind, defaultModelName, exposedKind, configRequired);
    }

    private ClassDef buildFactory(ClassDef namedConfigDef, ClassDef defaultConfigDef, ClassElement builderType, String factoryName, ClassElement languageModel, ClassElement languageModelKind, @Nullable ClassElement exposed) {
        ClassTypeDef namedConfigDefTypeDef = namedConfigDef.asTypeDef();
        ClassTypeDef builderTypeDef = ClassTypeDef.of((ClassElement)builderType);
        MethodDef.MethodBodyBuilder methodBody = (aThis, methodParameters) -> {
            VariableDef.MethodParameter methodParameter = (VariableDef.MethodParameter)methodParameters.get(0);
            return methodParameter.invoke(MethodDef.builder((String)"getBuilder").returns(TypeDef.of((TypedElement)builderType)).build(), new ExpressionDef[0]).returning();
        };
        return ((ClassDef.ClassDefBuilder)((ClassDef.ClassDefBuilder)((ClassDef.ClassDefBuilder)((ClassDef.ClassDefBuilder)((ClassDef.ClassDefBuilder)ClassDef.builder((String)factoryName).addModifiers(new Modifier[]{Modifier.PUBLIC})).addAnnotation(Factory.class)).addMethod(((MethodDef.MethodDefBuilder)((MethodDef.MethodDefBuilder)MethodDef.builder((String)"namedBuilder").addModifiers(new Modifier[]{Modifier.PROTECTED})).addAnnotation(AnnotationDef.builder(EachBean.class).addMember("value", (Object)new VariableDef.StaticField(ClassTypeDef.of((String)namedConfigDefTypeDef.getCanonicalName()), "class", TypeDef.of(Class.class))).build())).addParameter("config", (TypeDef)namedConfigDefTypeDef).returns(TypeDef.of((TypedElement)builderType)).build(methodBody))).addMethod(((MethodDef.MethodDefBuilder)((MethodDef.MethodDefBuilder)((MethodDef.MethodDefBuilder)((MethodDef.MethodDefBuilder)MethodDef.builder((String)"primaryBuilder").addModifiers(new Modifier[]{Modifier.PROTECTED})).addAnnotation(Bean.class)).addAnnotation(Primary.class)).addAnnotation(AnnotationDef.builder(Requires.class).addMember("beans", (Object)new VariableDef.StaticField(ClassTypeDef.of((String)defaultConfigDef.asTypeDef().getCanonicalName()), "class", TypeDef.of(Class.class))).build())).addParameter("config", (TypeDef)defaultConfigDef.asTypeDef()).returns(TypeDef.of((TypedElement)builderType)).build(methodBody))).addMethod(((MethodDef.MethodDefBuilder)((MethodDef.MethodDefBuilder)((MethodDef.MethodDefBuilder)((MethodDef.MethodDefBuilder)MethodDef.builder((String)"model").addModifiers(new Modifier[]{Modifier.PROTECTED})).addAnnotation(Context.class)).addAnnotation(AnnotationDef.builder(Bean.class).addMember("typed", (Object)new VariableDef.StaticField(ClassTypeDef.of((String)languageModelKind.getRawClassElement().getName()), "class", TypeDef.of(Class.class))).build())).addAnnotation(AnnotationDef.builder(EachBean.class).addMember("value", (Object)new VariableDef.StaticField(ClassTypeDef.of((String)builderTypeDef.getCanonicalName()), "class", TypeDef.of(Class.class))).build())).addParameter("builder", (TypeDef)builderTypeDef).returns((TypeDef)(exposed != null ? ClassTypeDef.of((ClassElement)exposed) : ClassTypeDef.of((ClassElement)languageModel))).build((aThis, parameters) -> {
            VariableDef.MethodParameter builder = (VariableDef.MethodParameter)parameters.get(0);
            return builder.invoke(MethodDef.builder((String)"build").returns((TypeDef)ClassTypeDef.of((ClassElement)languageModel)).build(), new ExpressionDef[0]).returning();
        }))).build();
    }

    private static void writeJavaSource(SourceGenerator generator, VisitorContext context, ClassElement element, String packageName, String simpleName, ObjectDef classDef, String modelKind) {
        context.visitGeneratedSourceFile(packageName, simpleName, new Element[]{element}).ifPresent(sourceFile -> {
            try {
                sourceFile.write(writer -> generator.write(classDef, writer));
            }
            catch (IOException e) {
                throw new ProcessingException((Element)element, "Error generating " + modelKind + "Configuration: " + e.getMessage());
            }
        });
    }

    private static ClassDef buildNamedConfigurationDef(String prefix, String configurationClassName, ClassElement model, ClassElement builderType, String[] requiredInjects, String[] optionalInjects, RecordDef commonConfig, MethodElement modelNameMethod, String defaultModelName) {
        FieldDef prefixField = ((FieldDef.FieldDefBuilder)FieldDef.builder((String)"PREFIX").ofType(TypeDef.of(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL})).initializer((ExpressionDef)new ExpressionDef.Constant(TypeDef.of(String.class), (Object)prefix)).build();
        String[] allExcludes = (String[])ArrayUtils.concat((Object[])requiredInjects, (Object[])optionalInjects);
        ClassDef.ClassDefBuilder classDefBuilder = (ClassDef.ClassDefBuilder)((ClassDef.ClassDefBuilder)((ClassDef.ClassDefBuilder)((ClassDef.ClassDefBuilder)ClassDef.builder((String)configurationClassName).addModifiers(new Modifier[]{Modifier.PUBLIC})).addAnnotation(AnnotationDef.builder(EachProperty.class).addMember("value", (Object)prefix).build())).addAnnotation(Context.class)).addField(prefixField).addField(((FieldDef.FieldDefBuilder)FieldDef.builder((String)"builder").addAnnotation(AnnotationDef.builder(ConfigurationBuilder.class).addMember("prefixes", (Object)"").addMember("excludes", Arrays.asList(allExcludes)).build())).initializer((ExpressionDef)ClassTypeDef.of((String)model.getName()).invokeStatic("builder", List.of(), TypeDef.of((TypedElement)builderType), new ExpressionDef[0])).ofType(TypeDef.of((TypedElement)builderType)).build()).addMethod(MethodDef.builder((String)"getBuilder").returns(TypeDef.of((TypedElement)builderType)).build((aThis, parameters) -> aThis.field("builder", TypeDef.of((TypedElement)builderType)).returning()));
        Langchain4jConfigVisitor.addCommonConstructor(builderType, commonConfig, classDefBuilder, modelNameMethod, defaultModelName, false);
        for (String requiredInject : requiredInjects) {
            Langchain4jConfigVisitor.addInjectionPoint(builderType, requiredInject, true, classDefBuilder);
        }
        for (String optionalInject : optionalInjects) {
            Langchain4jConfigVisitor.addInjectionPoint(builderType, optionalInject, false, classDefBuilder);
        }
        return classDefBuilder.build();
    }

    private static void addCommonConstructor(ClassElement builderType, RecordDef commonConfig, ClassDef.ClassDefBuilder classDefBuilder, MethodElement modelNameMethod, String defaultModelName, boolean isDefaultConfiguration) {
        MethodDef.MethodDefBuilder constructorBuilder = (MethodDef.MethodDefBuilder)((MethodDef.MethodDefBuilder)MethodDef.builder((String)CTOR_NAME).addAnnotation(ConfigurationInject.class)).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (commonConfig != null) {
            classDefBuilder.addAnnotation(AnnotationDef.builder(Requires.class).addMember("beans", (Object)new VariableDef.StaticField(commonConfig.asTypeDef(), "class", TypeDef.of(Class.class))).build());
            if (modelNameMethod != null && defaultModelName != null) {
                String modelNameMethodName = modelNameMethod.getName();
                constructorBuilder.addParameter(((ParameterDef.ParameterDefBuilder)ParameterDef.builder((String)modelNameMethodName, (TypeDef)TypeDef.of(String.class)).addAnnotation(AnnotationDef.builder(Bindable.class).addMember("defaultValue", (Object)defaultModelName).build())).build());
                constructorBuilder.addStatement(Langchain4jConfigVisitor.addModelNameStatement(builderType, modelNameMethodName));
            }
            constructorBuilder.addParameter(ParameterDef.builder((String)"config", (TypeDef)commonConfig.asTypeDef()).build());
            List properties = commonConfig.getProperties();
            for (PropertyDef property : properties) {
                if (property.getName().equals("enabled")) continue;
                constructorBuilder.addStatement((aThis, parameters) -> aThis.field("builder", TypeDef.of((TypedElement)builderType)).invoke(property.getName(), TypeDef.of(Void.TYPE), new ExpressionDef[]{((VariableDef.MethodParameter)parameters.get(parameters.size() - 1)).invoke(property.getName(), property.getType(), new ExpressionDef[0])}));
            }
            classDefBuilder.addMethod(constructorBuilder.build());
        } else if (modelNameMethod != null && !isDefaultConfiguration) {
            String modelNameMethodName = modelNameMethod.getName();
            classDefBuilder.addMethod(constructorBuilder.addParameter(((ParameterDef.ParameterDefBuilder)ParameterDef.builder((String)modelNameMethodName, (TypeDef)TypeDef.of(String.class)).addAnnotation(Parameter.class)).build()).build(Langchain4jConfigVisitor.addModelNameStatement(builderType, modelNameMethodName)));
        }
    }

    private static MethodDef.MethodBodyBuilder addModelNameStatement(ClassElement builderType, String modelNameMethodName) {
        return (aThis, methodParameters) -> {
            VariableDef.MethodParameter modelNameParameter = (VariableDef.MethodParameter)methodParameters.get(0);
            return aThis.field("builder", TypeDef.of((TypedElement)builderType)).invoke(modelNameMethodName, TypeDef.of(Void.TYPE), new ExpressionDef[]{modelNameParameter});
        };
    }

    private static ClassDef buildDefaultConfigurationDef(String prefix, String configurationClassName, ClassElement model, ClassElement builderType, String[] requiredInjects, String[] optionalInjects, RecordDef commonConfig, MethodElement modelNameMethod, String defaultModelName, boolean configRequired) {
        FieldDef prefixField = ((FieldDef.FieldDefBuilder)FieldDef.builder((String)"PREFIX").ofType(TypeDef.of(String.class)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL})).initializer((ExpressionDef)new ExpressionDef.Constant(TypeDef.of(String.class), (Object)prefix)).build();
        String[] allExcludes = (String[])ArrayUtils.concat((Object[])requiredInjects, (Object[])optionalInjects);
        ClassDef.ClassDefBuilder classDefBuilder = (ClassDef.ClassDefBuilder)((ClassDef.ClassDefBuilder)((ClassDef.ClassDefBuilder)((ClassDef.ClassDefBuilder)ClassDef.builder((String)configurationClassName).addModifiers(new Modifier[]{Modifier.PUBLIC})).addAnnotation(AnnotationDef.builder(ConfigurationProperties.class).addMember("value", (Object)prefix).build())).addAnnotation(Context.class)).addField(prefixField).addField(((FieldDef.FieldDefBuilder)FieldDef.builder((String)"builder").addAnnotation(AnnotationDef.builder(ConfigurationBuilder.class).addMember("prefixes", (Object)"").addMember("excludes", Arrays.asList(allExcludes)).build())).initializer((ExpressionDef)ClassTypeDef.of((String)model.getName()).invokeStatic("builder", List.of(), TypeDef.of((TypedElement)builderType), new ExpressionDef[0])).ofType(TypeDef.of((TypedElement)builderType)).build()).addMethod(MethodDef.builder((String)"getBuilder").returns(TypeDef.of((TypedElement)builderType)).addStatements(List.of(new StatementDef.Return((ExpressionDef)new VariableDef.Field((ExpressionDef)new VariableDef.This(), "builder", TypeDef.of((TypedElement)builderType))))).build());
        if (configRequired) {
            classDefBuilder.addAnnotation(AnnotationDef.builder(Requires.class).addMember("property", (Object)prefix).build());
        }
        for (String requiredInject : requiredInjects) {
            Langchain4jConfigVisitor.addInjectionPoint(builderType, requiredInject, true, classDefBuilder);
        }
        for (String optionalInject : optionalInjects) {
            Langchain4jConfigVisitor.addInjectionPoint(builderType, optionalInject, false, classDefBuilder);
        }
        if (commonConfig == null) {
            classDefBuilder.addAnnotation(AnnotationDef.builder(Requires.class).addMember("property", (Object)prefix).build());
        }
        Langchain4jConfigVisitor.addCommonConstructor(builderType, commonConfig, classDefBuilder, modelNameMethod, defaultModelName, true);
        return classDefBuilder.build();
    }

    private static void addInjectionPoint(ClassElement builderType, String requiredInject, boolean isRequired, ClassDef.ClassDefBuilder classDefBuilder) {
        MethodElement methodElement = builderType.getEnclosedElement(ElementQuery.ALL_METHODS.named(requiredInject)).orElse(null);
        if (methodElement != null && methodElement.hasParameters()) {
            TypeDef typeToInject = TypeDef.of((TypedElement)methodElement.getParameters()[0].getGenericType());
            String methodName = methodElement.getName();
            ParameterDef.ParameterDefBuilder parameterDefBuilder = ParameterDef.builder((String)methodName, (TypeDef)typeToInject);
            if (!isRequired) {
                parameterDefBuilder.addAnnotation(Nullable.class);
            }
            VariableDef.MethodParameter methodParameter = new VariableDef.MethodParameter(methodName, typeToInject);
            classDefBuilder.addMethod(((MethodDef.MethodDefBuilder)((MethodDef.MethodDefBuilder)MethodDef.builder((String)methodName).addModifiers(new Modifier[]{Modifier.PROTECTED})).returns(Void.TYPE).addParameter(parameterDefBuilder.build()).addAnnotation(Inject.class)).addStatements(List.of(new VariableDef.Local("builder", TypeDef.of((TypedElement)builderType)).invoke(methodName, TypeDef.of(Void.TYPE), List.of(methodParameter)))).build());
        }
    }

    private record ModelConfig(@NonNull ClassElement languageModel, @NonNull ClassElement languageModelKind, @NonNull ClassElement builderType, @Nullable ClassElement exposed, String modelKind, String modelSuffix, String modelName, String defaultModelName, boolean configRequired) {
        public ModelConfig(ClassElement languageModel, ClassElement languageModelKind, String defaultModelName, ClassElement exposed, boolean configRequired) {
            this(languageModel, languageModelKind, ModelConfig.resolveBuilder(languageModel), exposed, ModelConfig.resolveModelKind(languageModelKind), ModelConfig.resolveModelSuffix(languageModelKind), ModelConfig.resolveModelName(languageModel, languageModelKind), defaultModelName, configRequired);
        }

        private static String resolveModelSuffix(ClassElement languageModelKind) {
            return NameUtils.hyphenate((String)ModelConfig.resolveModelKind(languageModelKind), (boolean)true);
        }

        private static String resolveModelKind(ClassElement languageModelKind) {
            return MODEL_NAME_MAPPINGS.getOrDefault(languageModelKind.getSimpleName(), languageModelKind.getSimpleName());
        }

        private static String resolveModelName(ClassElement languageModel, ClassElement languageModelKind) {
            String modelKind = ModelConfig.resolveModelKind(languageModelKind);
            String modelName = NameUtils.decapitalize((String)languageModel.getSimpleName());
            if (modelName.endsWith(modelKind)) {
                modelName = modelName.substring(0, modelName.length() - modelKind.length());
            }
            return modelName;
        }

        private static ClassElement resolveBuilder(ClassElement languageModel) {
            ClassElement builderType = languageModel.getEnclosedElement(ElementQuery.ALL_METHODS.onlyStatic().onlyAccessible().onlyConcrete().named("builder")).map(MethodElement::getGenericReturnType).orElse(null);
            if (builderType == null) {
                throw new ProcessingException(null, "Model includes no builder() method: " + languageModel.getName());
            }
            return builderType;
        }

        public String getNamedPrefix() {
            return Langchain4jConfigVisitor.CONFIG_PREFIX + NameUtils.hyphenate((String)this.modelName, (boolean)true) + "." + this.modelSuffix + "s";
        }

        public String getDefaultPrefix() {
            return Langchain4jConfigVisitor.CONFIG_PREFIX + NameUtils.hyphenate((String)this.modelName, (boolean)true) + "." + this.modelSuffix;
        }

        public String getCommonPrefix() {
            return Langchain4jConfigVisitor.CONFIG_PREFIX + NameUtils.hyphenate((String)this.modelName, (boolean)true);
        }
    }

    record PropertyConfig(String name, String defaultValue, boolean required, boolean injected, boolean common) implements Lang4jConfig.Property
    {
        public PropertyConfig(AnnotationValue<Lang4jConfig.Property> annotation) {
            this((String)annotation.getRequiredValue("name", String.class), annotation.stringValue("defaultValue").orElse(null), annotation.booleanValue("required").orElse(false), annotation.booleanValue("injected").orElse(false), annotation.booleanValue("common").orElse(false));
        }

        public Class<? extends Annotation> annotationType() {
            return Lang4jConfig.Property.class;
        }
    }
}

