/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.liquibase.endpoint;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.micronaut.context.annotation.Type;
import java.io.IOException;
import java.time.Instant;
import javax.inject.Singleton;
import liquibase.changelog.RanChangeSet;

@Singleton
@Type(value={RanChangeSet.class})
public class RanChangeSetSerializer
extends JsonSerializer<RanChangeSet> {
    public void serialize(RanChangeSet value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("author", value.getAuthor());
        gen.writeStringField("changeLog", value.getChangeLog());
        gen.writeStringField("comments", value.getComments());
        gen.writeArrayFieldStart("contexts");
        for (String c : value.getContextExpression().getContexts()) {
            gen.writeString(c);
        }
        gen.writeEndArray();
        gen.writeStringField("dateExecuted", Instant.ofEpochMilli(value.getDateExecuted().getTime()).toString());
        gen.writeStringField("deploymentId", value.getDeploymentId());
        gen.writeStringField("description", value.getDescription());
        gen.writeStringField("execType", value.getExecType().toString());
        gen.writeStringField("id", value.getId());
        gen.writeArrayFieldStart("labels");
        for (String c : value.getLabels().getLabels()) {
            gen.writeString(c);
        }
        gen.writeEndArray();
        gen.writeStringField("checksum", value.getLastCheckSum() != null ? value.getLastCheckSum().toString() : null);
        gen.writeNumberField("orderExecuted", value.getOrderExecuted().intValue());
        gen.writeStringField("tag", value.getTag());
        gen.writeEndObject();
    }
}

