/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.liquibase;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.liquibase.AbstractLiquibaseMigration;
import io.micronaut.liquibase.LiquibaseConfigurationProperties;
import jakarta.inject.Singleton;
import javax.sql.DataSource;
import liquibase.resource.ResourceAccessor;
import org.grails.orm.hibernate.HibernateDatastore;
import org.grails.orm.hibernate.connections.HibernateConnectionSource;

@Singleton
@Requirements(value={@Requires(classes={HibernateDatastore.class}), @Requires(property="data-source")})
class GormMigrationRunner
extends AbstractLiquibaseMigration
implements BeanCreatedEventListener<HibernateDatastore> {
    GormMigrationRunner(ApplicationContext applicationContext, ResourceAccessor resourceAccessor) {
        super(applicationContext, resourceAccessor);
    }

    public HibernateDatastore onCreated(BeanCreatedEvent<HibernateDatastore> event) {
        HibernateDatastore hibernateDatastore = (HibernateDatastore)event.getBean();
        hibernateDatastore.getConnectionSources().forEach(connectionSource -> {
            String qualifier = connectionSource.getName();
            DataSource dataSource = ((HibernateConnectionSource)connectionSource).getDataSource();
            this.applicationContext.findBean(LiquibaseConfigurationProperties.class, Qualifiers.byName((String)qualifier)).ifPresent(liquibaseConfig -> this.run((LiquibaseConfigurationProperties)liquibaseConfig, dataSource));
        });
        return hibernateDatastore;
    }
}

