/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.liquibase;

import io.micronaut.context.env.Environment;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;

@Singleton
public class LiquibaseResourceAccessor
extends CompositeResourceAccessor {
    public LiquibaseResourceAccessor(Environment environment) {
        super(LiquibaseResourceAccessor.buildResourceAccessors(environment));
    }

    public SortedSet<String> list(String relativeTo, String path, boolean includeFiles, boolean includeDirectories, boolean recursive) throws IOException {
        return super.list(this.normalize(relativeTo), path, includeFiles, includeDirectories, recursive);
    }

    private String normalize(String path) {
        if (path != null) {
            if (path.startsWith("classpath:")) {
                path = path.substring(10);
            }
            if (path.startsWith("file:")) {
                path = path.substring(5);
            }
        }
        return path;
    }

    protected static List<ResourceAccessor> buildResourceAccessors(Environment environment) {
        ArrayList<ResourceAccessor> resourceAccessors = new ArrayList<ResourceAccessor>(2);
        resourceAccessors.add((ResourceAccessor)new ClassLoaderResourceAccessor(environment.getClassLoader()));
        resourceAccessors.add((ResourceAccessor)new FileSystemResourceAccessor(new File[0]));
        return resourceAccessors;
    }
}

