/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.liquibase.endpoint;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import java.time.Instant;
import java.util.Set;
import liquibase.change.CheckSum;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;

@Internal
@Introspected
@JsonInclude(value=JsonInclude.Include.ALWAYS)
final class RanChangeSetWrapper {
    private final RanChangeSet delegate;

    public RanChangeSetWrapper(RanChangeSet delegate) {
        this.delegate = delegate;
    }

    public String getAuthor() {
        return this.delegate.getAuthor();
    }

    public String getChangeLog() {
        return this.delegate.getChangeLog();
    }

    public String getComments() {
        return this.delegate.getComments();
    }

    public Set<String> getContexts() {
        return this.delegate.getContextExpression().getContexts();
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING)
    public Instant getDateExecuted() {
        return this.delegate.getDateExecuted().toInstant();
    }

    public String getDeploymentId() {
        return this.delegate.getDeploymentId();
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING)
    public ChangeSet.ExecType getExecType() {
        return this.delegate.getExecType();
    }

    public String getId() {
        return this.delegate.getId();
    }

    public Set<String> getLabels() {
        return this.delegate.getLabels().getLabels();
    }

    public String getStoredChangeLog() {
        return this.delegate.getStoredChangeLog();
    }

    public String getChecksum() {
        CheckSum cs = this.delegate.getLastCheckSum();
        return cs == null ? null : cs.toString();
    }

    public Integer getOrderExecuted() {
        return this.delegate.getOrderExecuted();
    }

    public String getTag() {
        return this.delegate.getTag();
    }
}

