/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.liquibase;

import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.env.Environment;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.util.Toggleable;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EachProperty(value="liquibase.datasources")
public class LiquibaseConfigurationProperties
implements Toggleable {
    public static final boolean DEFAULT_ENABLED = true;
    public static final boolean DEFAULT_DROPFIRST = false;
    public static final boolean DEFAULT_TESTROLLBACKONUPDATE = false;
    public static final boolean DEFAULT_ASYNC = false;
    private static final Logger LOG = LoggerFactory.getLogger(LiquibaseConfigurationProperties.class);
    private boolean async = false;
    private boolean enabled = true;
    private String changeLog;
    private String defaultSchema;
    private String liquibaseSchema;
    private boolean dropFirst = false;
    private String liquibaseTablespace;
    private String databaseChangeLogTable;
    private String databaseChangeLogLockTable;
    private String tag;
    private String contexts;
    private String labels;
    private boolean testRollbackOnUpdate = false;
    private String rollbackFilePath;
    private Map<String, String> parameters;
    private final String nameQualifier;

    public LiquibaseConfigurationProperties(@Parameter String name) {
        this.nameQualifier = name;
    }

    @PostConstruct
    void validate(Environment environment) {
        String badProp = "datasources." + this.nameQualifier + ".schema-generate";
        environment.getProperty(badProp, String.class).ifPresent(value -> {
            if (this.isEnabled() && !value.equalsIgnoreCase("NONE")) {
                throw new ConfigurationException(String.format("Cannot have configuration property '%s' if liquibase migration is enabled", badProp));
            }
        });
    }

    public void setTestRollbackOnUpdate(boolean testRollbackOnUpdate) {
        this.testRollbackOnUpdate = testRollbackOnUpdate;
    }

    public boolean isTestRollbackOnUpdate() {
        return this.testRollbackOnUpdate;
    }

    @Deprecated
    public boolean isIgnoreClasspathPrefix() {
        if (LOG.isWarnEnabled()) {
            LOG.warn("This configuration option is not available anymore in Liquibase Opensource edition.");
        }
        return false;
    }

    @Deprecated
    public void setIgnoreClasspathPrefix(boolean ignoreClasspathPrefix) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("This configuration option is not available anymore in Liquibase Opensource edition.");
        }
    }

    public String getDatabaseChangeLogLockTable() {
        return this.databaseChangeLogLockTable;
    }

    public void setDatabaseChangeLogLockTable(String databaseChangeLogLockTable) {
        this.databaseChangeLogLockTable = databaseChangeLogLockTable;
    }

    public String getDatabaseChangeLogTable() {
        return this.databaseChangeLogTable;
    }

    public void setDatabaseChangeLogTable(String databaseChangeLogTable) {
        this.databaseChangeLogTable = databaseChangeLogTable;
    }

    public String getLiquibaseTablespace() {
        return this.liquibaseTablespace;
    }

    public void setLiquibaseTablespace(String liquibaseTablespace) {
        this.liquibaseTablespace = liquibaseTablespace;
    }

    public String getLiquibaseSchema() {
        return this.liquibaseSchema;
    }

    public void setLiquibaseSchema(String liquibaseSchema) {
        this.liquibaseSchema = liquibaseSchema;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    public void setChangeLog(String changeLog) {
        this.changeLog = changeLog;
    }

    public void setRollbackFilePath(String rollbackFilePath) {
        this.rollbackFilePath = rollbackFilePath;
    }

    public String getRollbackFilePath() {
        return this.rollbackFilePath;
    }

    public File getRollbackFile() {
        if (this.rollbackFilePath == null) {
            return null;
        }
        return new File(this.rollbackFilePath);
    }

    public boolean isDropFirst() {
        return this.dropFirst;
    }

    public void setDropFirst(boolean dropFirst) {
        this.dropFirst = dropFirst;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setContexts(String contexts) {
        this.contexts = contexts;
    }

    public String getLabels() {
        return this.labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getNameQualifier() {
        return this.nameQualifier;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public boolean isAsync() {
        return this.async;
    }
}

