/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.liquibase.endpoint;

import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.jdbc.DataSourceResolver;
import io.micronaut.liquibase.LiquibaseConfigurationProperties;
import io.micronaut.liquibase.endpoint.LiquibaseReport;
import io.micronaut.management.endpoint.annotation.Endpoint;
import io.micronaut.management.endpoint.annotation.Read;
import io.micronaut.serde.annotation.SerdeImport;
import java.sql.SQLException;
import java.util.Collection;
import javax.sql.DataSource;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.StandardChangeLogHistoryService;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

@SerdeImport(value=RanChangeSet.class)
@Endpoint(id="liquibase")
public class LiquibaseEndpoint {
    public static final String NAME = "liquibase";
    private static final Logger LOG = LoggerFactory.getLogger(LiquibaseEndpoint.class);
    private final Collection<LiquibaseConfigurationProperties> liquibaseConfigurationProperties;
    private final ApplicationContext applicationContext;
    private final DataSourceResolver dataSourceResolver;

    public LiquibaseEndpoint(Collection<LiquibaseConfigurationProperties> liquibaseConfigurationProperties, ApplicationContext applicationContext, @Nullable DataSourceResolver dataSourceResolver) {
        this.liquibaseConfigurationProperties = liquibaseConfigurationProperties;
        this.applicationContext = applicationContext;
        this.dataSourceResolver = dataSourceResolver;
    }

    @Read
    public Publisher<LiquibaseReport> liquibaseMigrations() {
        return Flux.create(emitter -> {
            DatabaseFactory factory = DatabaseFactory.getInstance();
            if (this.liquibaseConfigurationProperties != null) {
                for (LiquibaseConfigurationProperties config : this.liquibaseConfigurationProperties) {
                    if (!config.isEnabled()) continue;
                    JdbcConnection jdbcConnection = null;
                    try {
                        DataSource dataSource = (DataSource)this.applicationContext.getBean(DataSource.class, Qualifiers.byName((String)config.getNameQualifier()));
                        if (this.dataSourceResolver != null) {
                            dataSource = this.dataSourceResolver.resolve(dataSource);
                        }
                        jdbcConnection = new JdbcConnection(dataSource.getConnection());
                        Database database = factory.findCorrectDatabaseImplementation((DatabaseConnection)jdbcConnection);
                        StandardChangeLogHistoryService service = new StandardChangeLogHistoryService();
                        service.setDatabase(database);
                        emitter.next((Object)new LiquibaseReport(config.getNameQualifier(), service.getRanChangeSets()));
                    }
                    catch (SQLException | DatabaseException ex) {
                        emitter.error(ex);
                    }
                    finally {
                        if (jdbcConnection == null) continue;
                        try {
                            jdbcConnection.close();
                        }
                        catch (DatabaseException e) {
                            if (!LOG.isWarnEnabled()) continue;
                            LOG.warn("Failed to close a connection to the liquibase datasource", (Throwable)e);
                        }
                    }
                }
            }
            emitter.complete();
        }, (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER);
    }
}

