/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.liquibase;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.jdbc.DataSourceResolver;
import io.micronaut.liquibase.AbstractLiquibaseMigration;
import io.micronaut.liquibase.LiquibaseConfigurationProperties;
import io.micronaut.scheduling.annotation.Async;
import jakarta.inject.Singleton;
import javax.sql.DataSource;
import liquibase.resource.ResourceAccessor;

@Singleton
class LiquibaseMigrationRunner
extends AbstractLiquibaseMigration
implements BeanCreatedEventListener<DataSource> {
    private final DataSourceResolver dataSourceResolver;

    LiquibaseMigrationRunner(ApplicationContext applicationContext, ResourceAccessor resourceAccessor, @Nullable DataSourceResolver dataSourceResolver) {
        super(applicationContext, resourceAccessor);
        this.dataSourceResolver = dataSourceResolver != null ? dataSourceResolver : DataSourceResolver.DEFAULT;
    }

    public DataSource onCreated(BeanCreatedEvent<DataSource> event) {
        DataSource dataSource = (DataSource)event.getBean();
        event.getBeanDefinition().getBeanName().ifPresent(name -> this.runMigration((String)name, dataSource));
        return dataSource;
    }

    private void runMigration(String name, DataSource dataSource) {
        this.applicationContext.findBean(LiquibaseConfigurationProperties.class, Qualifiers.byName((String)name)).ifPresent(cfg -> {
            DataSource unwrappedDataSource = this.dataSourceResolver.resolve(dataSource);
            this.run((LiquibaseConfigurationProperties)cfg, unwrappedDataSource);
        });
    }

    @Override
    @Async(value="io")
    void migrateAsync(LiquibaseConfigurationProperties config, DataSource dataSource) {
        super.migrateAsync(config, dataSource);
    }
}

