/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.liquibase.endpoint;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.liquibase.endpoint.RanChangeSetWrapper;
import io.micronaut.serde.annotation.Serdeable;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.changelog.RanChangeSet;

@Serdeable
public class LiquibaseReport {
    private String name;
    private List<RanChangeSet> changeSets;

    @Creator
    public LiquibaseReport(String name, List<RanChangeSet> changeSets) {
        this.name = name;
        this.changeSets = changeSets;
    }

    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public List<RanChangeSet> getChangeSets() {
        return this.changeSets;
    }

    @JsonProperty(value="changeSets")
    @Internal
    public List<RanChangeSetWrapper> getChangeSetWrappers() {
        return this.changeSets.stream().map(RanChangeSetWrapper::new).collect(Collectors.toList());
    }
}

