/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.enforcer;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.enforcer.rule.api.AbstractEnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.XmlUtil;

@Named(value="checkSnakeYaml")
public class CheckSnakeYaml
extends AbstractEnforcerRule {
    private final MavenProject project;
    private final Dependency snakeYaml;

    @Inject
    public CheckSnakeYaml(MavenProject project) {
        this.project = project;
        this.snakeYaml = new Dependency();
        this.snakeYaml.setGroupId("org.yaml");
        this.snakeYaml.setArtifactId("snakeyaml");
        this.snakeYaml.setScope("runtime");
    }

    public void execute() throws EnforcerRuleException {
        if (this.hasYamlConfiguration() && !this.hasSnakeYaml()) {
            String message = "YAML configuration file detected, but SnakeYAML is not on the runtime classpath. Make sure to add the following dependency:" + System.lineSeparator();
            message = message + this.toXml(this.snakeYaml);
            throw new EnforcerRuleException(message);
        }
    }

    private boolean hasYamlConfiguration() {
        return this.project.getResources().stream().anyMatch(this::hasYamlConfiguration);
    }

    private boolean hasSnakeYaml() {
        return this.project.getDependencies().stream().anyMatch(d -> d.getGroupId().equals(this.snakeYaml.getGroupId()) && d.getArtifactId().equals(this.snakeYaml.getArtifactId()));
    }

    private boolean hasYamlConfiguration(Resource resource) {
        File[] files = new File(resource.getDirectory()).listFiles();
        if (files != null) {
            return Arrays.stream(files).anyMatch(this::isYamlConfigurationFile);
        }
        return false;
    }

    private boolean isYamlConfigurationFile(File f) {
        String name = f.getName().toLowerCase();
        return name.startsWith("application") && (name.endsWith(".yml") || name.endsWith(".yaml"));
    }

    private String toXml(Dependency dependency) {
        StringReader dependencyXml = new StringReader("<dependency><groupId>" + dependency.getGroupId() + "</groupId><artifactId>" + dependency.getArtifactId() + "</artifactId><scope>" + dependency.getScope() + "</scope></dependency>");
        StringWriter result = new StringWriter();
        try {
            XmlUtil.prettyFormat((Reader)dependencyXml, (Writer)result);
            return result.toString();
        }
        catch (IOException e) {
            return dependencyXml.toString();
        }
    }

    public String toString() {
        return "CheckSnakeYaml";
    }
}

